% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_split_split_plot.R
\name{split_split_plot}
\alias{split_split_plot}
\title{Generates a Split Split Plot Design}
\usage{
split_split_plot(
  wp = NULL,
  sp = NULL,
  ssp = NULL,
  reps = NULL,
  type = 2,
  l = 1,
  plotNumber = 101,
  seed = NULL,
  locationNames = NULL,
  factorLabels = TRUE,
  data = NULL
)
}
\arguments{
\item{wp}{Number of whole plots, as an integer or a vector.}

\item{sp}{Number of sub plots per whole plot, as an integer or a vector.}

\item{ssp}{Number of sub-sub plots, as an integer or a vector.}

\item{reps}{Number of blocks (full replicates).}

\item{type}{Option for CRD or RCBD designs. Values are \code{type = 1} (CRD) or \code{type = 2} (RCBD). By default \code{type = 2}.}

\item{l}{Number of locations. By default \code{l = 1}.}

\item{plotNumber}{Numeric vector with the starting plot number for each location. By default \code{plotNumber = 101}.}

\item{seed}{(optional) Real number that specifies the starting seed to obtain reproducible designs.}

\item{locationNames}{(optional) Names for each location.}

\item{factorLabels}{(optional) If \code{TRUE} retain the levels
labels from the original data set otherwise, numeric labels will be
assigned. Default is \code{factorLabels =TRUE}.}

\item{data}{(optional) Data frame with label list of treatments.}
}
\value{
A list with two elements.
\itemize{
  \item \code{infoDesign} is a list with information on the design parameters.
  \item \code{fieldBook} is a data frame with the split split plot field book.
}
}
\description{
It randomly generates a split split plot design (SSPD) across locations.
}
\examples{
# Example 1: Generates a split split plot design SSPD with 5 whole plots, 2 sub-plots,
# 3 sub-sub plots, and 3 reps in an RCBD arrangement. This is for one location.
SSPD1 <- split_split_plot(wp = 4, sp = 2, ssp = 3, reps = 5, l = 1, 
                          plotNumber = 101, 
                          seed = 23, 
                          type = 2, 
                          locationNames = "FARGO")
SSPD1$infoDesign
head(SSPD1$fieldBook,12)

# Example 2: Generates a split split plot design SSPD with 2 whole plost 
# (Irrigation, No irrigation), 5 sub plots (4 types of fungicide + one control), and 
# 10 sub-sub plots (Ten varieties of beans), and 4 reps in an RCBD arrangement.
# This is for 3 locations. In this case, we show how to use the option data.
wp <- paste("IRR_", c("NO", "Yes"), sep = "") #Irrigation (2 Whole plots)
sp <- c("NFung", paste("Fung", 1:4, sep = "")) #Fungicides (5 Sub plots)
ssp <- paste("Beans", 1:10, sep = "") #Beans varieties (10 Sub-sub plots)
split_split_plot_Data <- data.frame(list(WHOLPLOT = c(wp, rep(NA, 8)), 
                                         SUBPLOT = c(sp, rep(NA, 5)),
                                         SUB_SUBPLOTS = ssp))
head(split_split_plot_Data, 10)
SSPD2 <- split_split_plot(reps = 4, l = 3, 
                          plotNumber = c(101, 1001, 2001),
                          seed = 23, 
                          type = 2, 
                          locationNames = c("A", "B", "C"),
                          data = split_split_plot_Data)
SSPD2$infoDesign
head(SSPD2$fieldBook,12)
             
}
\references{
Federer, W. T. (1955). Experimental Design. Theory and Application. New York, USA. The
Macmillan Company.
}
\author{
Didier Murillo [aut],
        Salvador Gezan [aut],
        Ana Heilman [ctb],
        Thomas Walk [ctb], 
        Johan Aparicio [ctb], 
        Richard Horsley [ctb]
}
