% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fct_latin_square.R
\name{latin_square}
\alias{latin_square}
\title{Generates a Latin Square Design}
\usage{
latin_square(
  t = NULL,
  reps = 1,
  plotNumber = 101,
  planter = "serpentine",
  seed = NULL,
  locationNames = NULL,
  data = NULL
)
}
\arguments{
\item{t}{Number of treatments.}

\item{reps}{Number of full resolvable squares. By default \code{reps = 1}.}

\item{plotNumber}{Starting plot number. By default \code{plotNumber = 101}.}

\item{planter}{Option for \code{serpentine} or \code{cartesian} arrangement. By default \code{planter = 'serpentine'}.}

\item{seed}{(optional) Real number that specifies the starting seed to obtain reproducible designs.}

\item{locationNames}{(optional) Name for the location.}

\item{data}{(optional) Data frame with label list of treatments.}
}
\value{
A list with information on the design parameters.

Data frame with the latin square field book.

A list with two elements.
\itemize{
  \item \code{infoDesign} is a list with information on the design parameters.
  \item \code{fieldBook} is a data frame with the latin square field book.
}
}
\description{
Randomly generates a latin square design of up 10 treatments.
}
\examples{
# Example 1: Generates a latin square design with 4 treatments and 2 reps.
latinSq1 <- latin_square(t = 4,
                         reps = 2,
                         plotNumber = 101,
                         planter = "cartesian",
                         seed = 1980)
print(latinSq1)
summary(latinSq1)
head(latinSq1$fieldBook)

# Example 2: Generates a latin square design with 5 treatments and 3 reps.
latin_data <- data.frame(list(ROW = paste("Period", 1:5, sep = ""),
                              COLUMN = paste("Cow", 1:5, sep = ""),
                              TREATMENT = paste("Diet", 1:5, sep = "")))
print(latin_data)
latinSq2 <- latin_square(t = NULL,
                         reps = 3,
                         plotNumber = 101,
                         planter = "cartesian",
                         seed = 1981,
                         data = latin_data)
latinSq2$squares
latinSq2$plotSquares
head(latinSq2$fieldBook)

}
\references{
Federer, W. T. (1955). Experimental Design. Theory and Application. New York, USA. The
Macmillan Company.
}
\author{
Didier Murillo [aut],
        Salvador Gezan [aut],
        Ana Heilman [ctb],
        Thomas Walk [ctb], 
        Johan Aparicio [ctb],
        Thiago de Paula Oliveira[ctb] 
        Richard Horsley [ctb]
}
