% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/FMAT.R
\name{FMAT_query}
\alias{FMAT_query}
\title{Prepare a data.table of queries and variables for the FMAT.}
\usage{
FMAT_query(
  query = "Text with [MASK], optionally with {TARGET} and/or {ATTRIB}.",
  MASK = .(),
  TARGET = .(),
  ATTRIB = .(),
  unmask.id = 1
)
}
\arguments{
\item{query}{Query text (should be a character string/vector
with at least one \code{[MASK]} token).
Multiple queries share the same set of
\code{MASK}, \code{TARGET}, and \code{ATTRIB}.
For multiple queries with different
\code{MASK}, \code{TARGET}, and/or \code{ATTRIB},
please use \code{\link{FMAT_query_bind}} to combine them.}

\item{MASK}{A named list of \code{[MASK]} target words.
Must be single words in the vocabulary of a certain masked language model.
For model vocabulary, see, e.g.,
\url{https://huggingface.co/bert-base-uncased/raw/main/vocab.txt}

Note that infrequent words may be not included in a model's vocabulary,
and in this case you may insert the words into the context by
specifying either \code{TARGET} or \code{ATTRIB}.}

\item{TARGET, ATTRIB}{A named list of Target/Attribute words or phrases.
If specified, then \code{query} must contain
\code{{TARGET}} and/or \code{{ATTRIB}} (in all uppercase and in braces)
to be replaced by the words/phrases.}

\item{unmask.id}{If there are multiple \code{[MASK]} in \code{query},
this argument will be used to determine which one is to be unmasked.
Defaults to the 1st \code{[MASK]}.}
}
\value{
A data.table of queries and variables.
}
\description{
Prepare a data.table of queries and variables for the FMAT.
}
\examples{
FMAT_query("[MASK] is a nurse.", MASK = .(Male="He", Female="She"))

FMAT_query(
  c("[MASK] is {TARGET}.", "[MASK] works as {TARGET}."),
  MASK = .(Male="He", Female="She"),
  TARGET = .(Occupation=cc("a doctor, a nurse, an artist"))
)

FMAT_query(
  "The [MASK] {ATTRIB}.",
  MASK = .(Male=cc("man, boy"),
           Female=cc("woman, girl")),
  ATTRIB = .(Masc=cc("is masculine, has a masculine personality"),
             Femi=cc("is feminine, has a feminine personality"))
)

FMAT_query(
  "The association between {TARGET} and {ATTRIB} is [MASK].",
  MASK = .(H="strong", L="weak"),
  TARGET = .(Flower=cc("rose, iris, lily"),
             Insect=cc("ant, cockroach, spider")),
  ATTRIB = .(Pos=cc("health, happiness, love, peace"),
             Neg=cc("death, sickness, hatred, disaster"))
)

}
\seealso{
\code{\link{FMAT_load}}

\code{\link{FMAT_query_bind}}

\code{\link{FMAT_run}}
}
