% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/mlp_net.R
\name{mlp_net-export-import}
\alias{mlp_export_fcnn}
\alias{mlp_import_fcnn}
\alias{mlp_net-export-import}
\title{Export and import multilayer perceptron network to/from a text file
in FCNN format}
\usage{
mlp_export_fcnn(net, fname)

mlp_import_fcnn(fname)
}
\arguments{
\item{net}{an object of \code{mlp_net} class}

\item{fname}{character string with the filename}
}
\value{
\code{mlp_export_fcnn} returns logical value, TRUE if export was successful, FALSE otherwise.

        \code{mlp_ipport_fcnn} returns  an object of \code{mlp_net} class or NULL, if import failed.
}
\description{
These functions can be used to export and import multilayer perceptron
network to/from a text file in FCNN format.
}
\details{
Files are organised as follows:
\itemize{
 \item the first comment (beginning with \code{#}) is treated as network information (name) string,
 \item all other comments are ignored,
 \item network structure is represented by five lines of numbers:
    \itemize{
     \item the first line determines numbers of neurons in consecutive layers,
     \item the second line of 0's and 1's determines which weights are turned off/on,
     \item the third line contains active weights' values,
     \item the last two lines determine hidden and output layer activation functions
           and their slope parameters.
     }
 }
}
\examples{
# create a 2-3-1 network
net <- mlp_net(c(2, 3, 1))
# randomise weights
net <- mlp_rnd_weights(net)
# Show the network
show(net)
# export network
mlp_export_fcnn(net, "test.net")
# Show the output file
file.show("test.net")
# import network
net2 <- mlp_import_fcnn("test.net")
# Show the imported network
show(net2)
}
\seealso{
\code{\linkS4class{mlp_net}} for network representation details.
}

