% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated.R
\name{adjust_infection_to_report}
\alias{adjust_infection_to_report}
\title{Adjust from Case Counts by Infection Date to Date of Report}
\usage{
adjust_infection_to_report(
  infections,
  delay_defs,
  reporting_model,
  reporting_effect,
  type = "sample",
  truncate_future = TRUE
)
}
\arguments{
\item{infections}{\verb{<data.table>} containing a \code{date} variable and a numeric
\code{cases} variable.}

\item{delay_defs}{A list of single row data.tables that each  defines a
delay distribution (model, parameters and maximum delay for each model).
See \code{\link[=lognorm_dist_def]{lognorm_dist_def()}} for an example of the structure.}

\item{reporting_model}{A function that takes a single numeric vector as an
argument and returns a single numeric vector. Can be used to apply stochastic
reporting effects. See the examples for details.}

\item{reporting_effect}{A numeric vector of length 7 that allows the scaling
of reported cases by the day on which they report (1 = Monday, 7 = Sunday).
By default no scaling occurs.}

\item{type}{Character string indicating the method to use to transform
counts. Supports either "sample"  which approximates sampling or "median"
would shift by the median of the distribution.}

\item{truncate_future}{Logical, should cases be truncated if they occur
after the first date reported in the data. Defaults to \code{TRUE}.}
}
\value{
A \code{data.table} containing a \code{date} variable (date of report) and a
\code{cases} variable. If \code{return_onset = TRUE} there will be a third variable
\code{reference} which indicates what the date variable refers to.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}}
Maps from cases by date of infection to date of report via date of
onset.
}
\examples{
\donttest{
# This function is deprecated and its functionality can now be accessed
# from [simulate_secondary()].
# Here are some examples of how to use [simulate_secondary()] to replace
# adjust_infection_to_report().

# Old (using adjust_infection_to_report()):
# Define example case data
cases <- data.table::copy(example_confirmed)
cases <- cases[, cases := as.integer(confirm)]
# Define a simple reporting delay distribution
delay_def <- lognorm_dist_def(
 mean = 5, mean_sd = 1, sd = 3, sd_sd = 1,
 max_value = 30, samples = 1, to_log = TRUE
)
report <- adjust_infection_to_report(
 cases,
 delay_defs = list(delay_def),
 reporting_model = function(n) rpois(length(n), n)
)
print(report)

# New (using simulate_secondary()):
cases <- data.table::copy(example_confirmed)
cases <- cases[, primary := as.integer(confirm)]
uncertain_delay <- LogNormal(
 mean = Normal(5, 1), sd = Normal(3, 1),
 max = 30
)
delay <- fix_dist(uncertain_delay, strategy = "sample")
report <- simulate_secondary(
 cases,
 delays = delay_opts(delay),
 obs = obs_opts(family = "poisson")
)
print(report)
}
}
\keyword{internal}
