% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ALGO__IHS.R
\name{config_ihs}
\alias{config_ihs}
\title{Configuration object for the Improved Harmony Search Algorithm}
\usage{
config_ihs(
  iterations,
  population_size,
  iterations_same_cost = NULL,
  absolute_tol = NULL,
  considering_rate = 0.5,
  min_adjusting_rate = 0.3,
  max_adjusting_rate = 0.99,
  min_distance_bandwidth = 1e-04,
  max_distance_bandwidth = 1
)
}
\arguments{
\item{iterations}{maximum number of iterations.}

\item{population_size}{number of solutions in the harmony memory.}

\item{iterations_same_cost}{maximum number of consecutive iterations with the \emph{same}
(see the parameter \code{absolute_tol}) best cost before ending the minimization. If \code{NULL} the
minimization continues for the number of iterations specified by the parameter \code{iterations}.
Default is \code{NULL}.}

\item{absolute_tol}{absolute tolerance when comparing best costs from consecutive iterations.
If \code{NULL} the machine epsilon is used. Default is \code{NULL}.}

\item{considering_rate}{probability for each component of a newly generated solution
to be recalled from the harmony memory.}

\item{min_adjusting_rate}{minimum value of the pitch adjustment probability.}

\item{max_adjusting_rate}{maximum value of the pitch adjustment probability.}

\item{min_distance_bandwidth}{minimum amplitude of the random pitch adjustment.}

\item{max_distance_bandwidth}{maximum amplitude of the random pitch adjustment.}
}
\value{
\code{config_ihs} returns an object of class \code{IHSConfig}.
}
\description{
Create a configuration object for the Improved Harmony Search Algorithm (IHS).
At minimum the number of iterations (parameter \code{iterations}) and the number of
solutions in the harmony memory (parameter \code{population_size}) have to be provided.
}
\references{
\insertRef{Mahdavi2007}{EmiR}
}
