% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/readTALIS.R
\name{readTALIS}
\alias{readTALIS}
\title{Connect to TALIS Data}
\usage{
readTALIS(
  path,
  countries,
  isced = "b",
  dataLevel = "teacher",
  forceReread = FALSE,
  verbose = TRUE
)
}
\arguments{
\item{path}{a character vector to the full directory path(s) to the TALIS SPSS files (.sav)}

\item{countries}{a character vector of the country/countries to include using the
three-digit ISO country code. A list of country codes can be found in
the TALIS codebook, or you can use
\url{https://en.wikipedia.org/wiki/ISO_3166-1#Current_codes}.
You can use \code{*} to indicate all countries available.}

\item{isced}{a character value that is one of \code{a}, \code{b}, or \code{c}. \code{a} stands for \emph{Primary Level},
\code{b} is for \emph{Lower Secondary Level}, and \code{c} is for \emph{Upper Secondary Level}. Default to \code{b}.}

\item{dataLevel}{a character value that indicates which data level to be used. It can be \code{teacher} (the default) or \code{school} (see details).}

\item{forceReread}{a logical value to force rereading of all processed data. Defaults to \code{FALSE}.
Setting \code{forceReread} to be \code{TRUE} will cause \code{readTALIS} data to be reread and increase processing time.}

\item{verbose}{a logical value that will determine if you want verbose output while the function is running to indicate the progress.
Defaults to \code{TRUE}.}
}
\value{
an \code{edsurvey.data.frame} for a single specified country or
  an \code{edsurvey.data.frame.list} if multiple countries specified
}
\description{
Opens a connection to a TALIS data file and
             returns an \code{edsurvey.data.frame} with
             information about the file and data.
}
\details{
Reads in the unzipped files downloaded from the TALIS database using the OECD Repository (\url{https://www.oecd.org/education/talis/}).
       If \code{dataLevel} is set to be \code{teacher}, it treats the teacher data file as the main dataset, and merges school data into teacher data for
       each country automatically. Use this option if wanting to analyze just teacher variables, or both teacher and school level variables together. 
       If \code{dataLevel} is set \code{school}, it uses only the school data file (no teacher data will be available).
}
\examples{
\dontrun{
#TALIS 2018 - school level data for all countries
talis18 <- readTALIS(path = "~/TALIS/2018", 
                     isced = "b", 
                     dataLevel = "school", 
                     countries = "*")

#unweighted summary
result <- summary2(talis18, "tc3g01", weightVar = "")

#print usa results to console
result$usa

# the following call returns an edsurvey.data.frame to TALIS 2013 
# for US teacher-level data at secondary level
usa2013 <- readTALIS(path = "~/TALIS/2013", isced = "b",
                     dataLevel = "teacher", countries = "usa")

# extract a data.frame with a few variables
gg <- getData(usa2013, c("tt2g05b", "tt2g01"))  
head(gg)

# conduct an analysis on the edsurvey.data.frame
edsurveyTable(tt2g05b ~ tt2g01, data = usa2013) 
}
}
\references{
Organisation for Economic Co-operation and Development. (2018). \emph{TALIS 2018 technical report}. Retrieved from \emph{\url{https://www.oecd.org/education/talis/TALIS_2018_Technical_Report.pdf}}
}
\seealso{
\code{\link{getData}} and \code{\link{downloadTALIS}}
}
\author{
Paul Bailey, Tom Fink, and Trang Nguyen
}
