% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EValue.R
\name{stronger_than}
\alias{stronger_than}
\title{Estimate proportion of population effect sizes above or below a threshold in a meta-analysis}
\usage{
stronger_than(.q, .yr, .vyr = NULL, .t2, .vt2 = NULL, CI.level = 0.95,
  .tail)
}
\arguments{
\item{.q}{True effect size that is the threshold for "scientific importance"}

\item{.yr}{Pooled point estimate from meta-analysis}

\item{.vyr}{Estimated variance of pooled point estimate from meta-analysis}

\item{.t2}{Estimated heterogeneity (tau^2) from meta-analysis}

\item{.vt2}{Estimated variance of tau^2 from meta-analysis}

\item{CI.level}{Confidence level as a proportion}

\item{.tail}{\code{above} for the proportion of effects above \code{.q}; \code{below} for
the proportion of effects below \code{.q}.}
}
\description{
This is a wrapper for \code{confounded_meta} that estimates, without any 
adjustment for confounding bias, the proportion of effect sizes above or
below a specified threshold. Effect sizes may be of any type (they need not
be relative risks).
}
