% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elastic.R
\name{elastic}
\alias{elastic}
\alias{elastic.ER}
\title{Elastic-net modelling of ER objects.}
\usage{
elastic(er, ...)

\method{elastic}{ER}(
  er,
  effect,
  alpha = 0.5,
  newdata = NULL,
  validation,
  segments = NULL,
  measure = measure,
  family = family,
  ...
)
}
\arguments{
\item{er}{Object of class \code{ER}.}

\item{...}{Additional arguments for \code{pls::cvsegments}.}

\item{effect}{The effect to be used as response.}

\item{alpha}{The elasticnet mixing parameter.}

\item{newdata}{Optional new data matrix for prediction.}

\item{validation}{Optional validation parameters.}

\item{segments}{number of segments or list of segments (optional)}

\item{measure}{Type of performance summary, default = 'class' (see \code{\link{glmnet}})}

\item{family}{Type of model response, default = 'multinomial'.}
}
\description{
Elastic-net modelling of ER objects.
}
\examples{
data(MS, package = "ER")
er <- ER(proteins ~ MS * cluster, data = MS)
elasticMod <- elastic(er, 'MS', validation = "CV")
sum(elasticMod$classes == MS$MS)
plot(elasticMod)            # Model fit
plot(elasticMod$glmnet.fit) # Coefficient trajectories
}
