% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ELMCoxBAR.R
\name{ELMCoxBAR}
\alias{ELMCoxBAR}
\title{ELMCoxBAR}
\usage{
ELMCoxBAR(x, y, Kernel_type = "lin_kernel", Kernel_para = c(2, 1),
  penality = 0, maxiter = 5, ...)
}
\arguments{
\item{x}{The covariates(predictor variables) of training data.}

\item{y}{Survival time and censored status of training data. Must be a Surv  \code{survival} object}

\item{Kernel_type}{Type of kernel matrix. Currently four options avaibable. "RBF_kernel",a RBF kernel;"lin_kernel" , a linear kernel;poly_kernel ,a polynomial kernel;sigmoid_kernel, a sigmoid kernel. Default is "lin_kernel".}

\item{Kernel_para}{Parameters for different types of kernels. A single value for RBF and linear kernels. A vector for polynomial and sigmoid kernels and progam stops if only a single value is supplied. However, if the vector of values is supplied in the cases of RBF and liner kernels, only the first value will be used. Default is a vector value "c(2,1)".}

\item{penality}{Currently, penality is defaulted to 0 to train an ELMCoxBAR model.}

\item{maxiter}{Maximum values of iterations to update the CoxBAR estimator. Default is 5.}

\item{...}{Additional arguments for  glmnet.}
}
\value{
Object of class \code{ELMCoxBAR} with elements
  \tabular{ll}{
      \code{elmcox}    \tab  A glmnet type model. See \code{glmnet} for details. \cr
      \code{trainx} \tab  Training data covariates. \cr
         \code{kerneltype} \tab  Type of kernel matrix used in training. kerneltype=1,a RBF kernel;kerneltype=2 , a linear kernel;kerneltype=3 ,a polynomial kernel;kerneltype=4, a sigmoid kernel. \cr
  \code{Kernel_para} \tab  Parameters used in training. A single value for kerneltype=1 or 2. A vector for kerneltype=3 or 4. \cr
  }
}
\description{
Extreme Learning Machine Cox Model for High Dimensional Survival Analysis
}
\examples{
set.seed(123)
require(ELMSurv)
require(survival)
#Lung DATA
data(lung)
lung=na.omit(lung)
lung[,3]=lung[,3]-1
n=dim(lung)[1]
L=sample(1:n,ceiling(n*0.5))
trset<-lung[L,]
teset<-lung[-L,]
rii=c(2,3)
# Default with lin_kernel 
elmsurvmodel=ELMCoxBAR(x=trset[,-rii],y=Surv(trset[,rii[1]], trset[,rii[2]]))
# with  the RBF kernel
elmsurvmodel=ELMCoxBAR(x=trset[,-rii],y=Surv(trset[,rii[1]], 
trset[,rii[2]]),Kernel_type="RBF_kernel",Kernel_para=c(2,1))
#The predicted linear predictor
testprelin=predict(elmsurvmodel,teset[,-c(rii)])
}
\references{
\itemize{
  \item Wang, H, Li, G. Extreme learning machine Cox model for high-dimensional survival analysis. Statistics in Medicine. 2019; 38:2139-2156.
 }
}
\author{
Hong Wang
}
