% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/include_IRF.R
\name{include_IRF}
\alias{include_IRF}
\title{Embed the graphs of Impulse Response Function (IRF) in R Markdown document}
\usage{
include_IRF(path = ".", model = "", IRF = "")
}
\arguments{
\item{path}{A character string for the path to the IRF graph.}

\item{model}{Object or a character string representing the name of the \code{Dynare} model file (\code{.mod} or \code{.dyn} extension)}

\item{IRF}{A character string for the name of the Impulse Response Function as defined in the \code{Dynare} codes.}
}
\value{
Set of \code{Dynare} (open-source software for DSGE modelling) outputs
}
\description{
Use this function to include \code{Dynare} IRF into the R Markdown document
}
\examples{
\dontrun{
library(DynareR)

demo(bkk)

include_IRF(model="bkk",IRF="E_H2")

# The above code fetches the IRF graph from "bkk/bkk/graphs/bkk_IRF_E_H2.pdf"

# Alternatively, the `path` argument can be used as follows

include_IRF(path="bkk/bkk/graphs/bkk_IRF_E_H2.pdf")
}
}
\references{
Bob Rudis (2015).Running Go language chunks in R Markdown (Rmd) files. Available at:  https://gist.github.com/hrbrmstr/9accf90e63d852337cb7

Yihui Xie (2019). knitr: A General-Purpose Package for Dynamic Report Generation in R. R package version 1.24.

Yihui Xie (2015) Dynamic Documents with R and knitr. 2nd edition. Chapman and Hall/CRC. ISBN 978-1498716963

Yihui Xie (2014) knitr: A Comprehensive Tool for Reproducible Research in R. In Victoria Stodden, Friedrich Leisch and Roger D. Peng, editors, Implementing Reproducible Computational Research. Chapman and Hall/CRC. ISBN 978-1466561595
}
\seealso{
Other important functions: 
\code{\link{DynareR}},
\code{\link{add_path}()},
\code{\link{eng_dynare}()},
\code{\link{import_log}()},
\code{\link{run_dynare}()},
\code{\link{run_models}()},
\code{\link{set_dynare_version}()},
\code{\link{set_octave_path}()},
\code{\link{write_dyn}()},
\code{\link{write_mod}()}
}
\author{
\href{https://smati.com.ng}{Sagiru Mati}, \href{https://orcid.org/0000-0003-1413-3974}{ORCID: 0000-0003-1413-3974}
\itemize{
\item Yusuf Maitama Sule (Northwest) University Kano, Nigeria
\item SMATI Academy
}
}
\concept{important functions}
\keyword{documentation}
