% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mockDrugExposure.R
\name{mockDrugExposure}
\alias{mockDrugExposure}
\title{Mock Drug exposure tables for ingredients of interest}
\usage{
mockDrugExposure(
  drug_exposure = NULL,
  concept_ancestor = NULL,
  concept_relationship = NULL,
  concept = NULL,
  drug_strength = NULL,
  drug_exposure_size = 100,
  patient_size = 50,
  amount_val = c(1, 2, 3),
  den_val = c(1, 10, 100),
  unit = c("", "actuat", "mg", "mL", "mL", "h"),
  num_val = c(1, 2, 3),
  seed = 1
)
}
\arguments{
\item{drug_exposure}{drug exposure table}

\item{concept_ancestor}{concept_ancestor table}

\item{concept_relationship}{concept_relationship table}

\item{concept}{concept table}

\item{drug_strength}{drug strength table}

\item{drug_exposure_size}{the sample size of the drug exposure table}

\item{patient_size}{the number of unique patients in the drug exposure table}

\item{amount_val}{vector of possible numeric amount value for the drug in the drug strength table}

\item{den_val}{vector of possible numeric denominator value for the drug in drug strength table}

\item{unit}{vector of possible unit type drug strength table please select from "", "actuat", "mg", "mL", "mL", "h".}

\item{num_val}{vector of possible numeric numerator denominator value drug strength table}

\item{seed}{seed to make results reproducible}
}
\value{
CDMConnector CDM reference object to duckdb database with mock data include  concept_ancestor, concept, drug_strength, drug_exposure tables
}
\description{
Mock Drug exposure tables for ingredients of interest
}
