% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/NormalESPlot2DHP.R
\name{NormalESPlot2DHP}
\alias{NormalESPlot2DHP}
\title{Plots normal ES against holding period}
\usage{
NormalESPlot2DHP(...)
}
\arguments{
\item{...}{The input arguments contain either return data or else mean and
 standard deviation data. Accordingly, number of input arguments is either 3
 or 4. In case there 3 input arguments, the mean and standard deviation of
 data is computed from return data. See examples for details.

returns Vector of daily geometric return data

 mu Mean of daily geometric return data

 sigma Standard deviation of daily geometric return data

 cl ES confidence level and must be a scalar

 hp ES holding period and must be a vector}
}
\description{
Plots the ES of a portfolio against holding period assuming that P/L distribution is
normally distributed, for specified confidence level and holding period.
}
\examples{
# Computes ES given geometric return data
   data <- runif(5, min = 0, max = .2)
   NormalESPlot2DHP(returns = data, cl = .95, hp = 60:90)

   # Computes v given mean and standard deviation of return data
   NormalESPlot2DHP(mu = .012, sigma = .03, cl = .99, hp = 40:80)
}
\author{
Dinesh Acharya
}
\references{
Dowd, K. Measuring Market Risk, Wiley, 2007.
}

