% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DistributionOptimization.R
\name{DistributionOptimization}
\alias{DistributionOptimization}
\title{Distribution Fitting}
\usage{
DistributionOptimization(Data, Modes, Monitor = 1,
  SelectionMethod = "UnbiasedTournament",
  MutationMethod = "Uniform+Focused",
  CrossoverMethod = "WholeArithmetic", PopulationSize = Modes * 3 * 25,
  MutationRate = 0.7, Elitism = 0.05, CrossoverRate = 0.2,
  Iter = Modes * 3 * 200, OverlapTolerance = NULL,
  IsLogDistribution = rep(F, Modes), ErrorMethod = "chisquare",
  NoBins = NULL, Seed = NULL, ConcurrentInit = F, ParetoRad = NULL)
}
\arguments{
\item{Data}{Data to be modelled}

\item{Modes}{Number of expected Modes}

\item{Monitor}{0:no monitoring, 1: status messages, 2: status messages and plots, 3: status messages, plots and calculated error-measures}

\item{SelectionMethod}{1: LinearRank selection
4: UnbiasedTournament
5: FitnessProportional selection}

\item{MutationMethod}{1: UniformRandom mutation
2: NonuniformRandom mutation
4: Focused mutation,  alternative random mutation around solution
5: GaussMutationCust
6: TwoPhaseMutation - mutation is uniform random during the first half of iterations, and than focuses around current solution}

\item{CrossoverMethod}{1: single point crossover
2: whole arithmetic crossover
3: local arithmetic crossover
4: blend crossover
5: GaussCrossover - exchange complete gaussian components
6: MultiPointCrossover  - Random amount of information between mixtures get exchanged}

\item{PopulationSize}{Size of the population}

\item{MutationRate}{amount (0..1) of population that gets mutated}

\item{Elitism}{amount of best individuals that will survive generation unchanged}

\item{CrossoverRate}{amount of individuals that will be used for crossover}

\item{Iter}{number of iterations of this algorithm}

\item{OverlapTolerance}{ratio between Chi-Square and OverlapError (only if FitnessMethod = 4 (Chi2ValueWithOverlap))}

\item{IsLogDistribution}{which gauss components should be considered as log gaussian}

\item{ErrorMethod}{"pde": fitting is measured by pareto density estimation. "chisquare": fitting is measured by Chi-Square test}

\item{NoBins}{Number of Bins that will be used for evaluating fitting}

\item{Seed}{Random Seed for reproducible results}

\item{ConcurrentInit}{If true, before initialization a number of short optimizations are done to find a good starting point for evolution}

\item{ParetoRad}{Pareto Radius for Pareto Density Estimation and its plots}
}
\value{
The GA object containing the evolutionary training and a description of the final GMM consisting of means, sdevs and weights.
}
\description{
Fits a Gaussian Mixture Model onto a Dataset by minimizing a fitting error through evolutionary optimization. Every individual encodes one GMM.
Details over the evolutionary process itself can be taken from the 'GA' package. \link[GA]{ga}
}
\examples{
DistributionOptimization(c(rnorm(200),rnorm(200,3)), 2,Iter = 15)

}
\author{
Florian Lerch

Jorn Lotsch

Alfred Ultsch
}
