% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/peelingOneIterate.R
\name{peelingOneIterate}
\alias{peelingOneIterate}
\title{A Function to Apply the Peeling Algorithm in a Single Copy Number Matrix}
\usage{
peelingOneIterate(
  X,
  posDT,
  gain = TRUE,
  nullDist = NULL,
  threshold = NULL,
  numIters = 5
)
}
\arguments{
\item{X}{A matrix of normalized gene-level copy number data (rows = genes, columns = subjects).}

\item{posDT}{A data frame containing genomic position information for the genes in X.}

\item{gain}{A logical value indicating whether gains (TRUE) or losses (FALSE) will be peeled.

Default = TRUE.}

\item{nullDist}{An empirical null distribution produced by the cyclic shift algorithm.

Default = NULL.}

\item{threshold}{A tuning parameter that controls the size of the peeled region.  Rows of X

with mean copy number less than threshold will not be peeled.  Default = NULL.}

\item{numIters}{The number of times peelingOne will be iterated.  Default = 5.}
}
\value{
A list containing two elements: X and interval.  X is an updated version of the input
copy number matrix in which the peak at k has been removed, and interval is genomic region
containing k.  By construction, interval cannot extend beyond the chromosome arm containing k.
}
\description{
This function iteratively applies the peelingOne function, thereby identifying multiple
}
\details{
peaks across the genome in a single cohort.  Gains and losses should be analyzed separately.
}
\examples{
lusc=pD[["X"]]

 posDT=pD[["posDT"]]

 gain = TRUE

 nullDist = NULL

 threshold = NULL

 numIters = 3

 peeledLusc=peelingOneIterate(X=lusc,posDT=posDT,gain=TRUE,nullDist=NULL,threshold=NULL,numIters=3)   

}
