/*
 * Decompiled with CFR 0.152.
 */
package org.rosuda.deducer.widgets;

import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GraphicsConfiguration;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.util.HashMap;
import java.util.Vector;
import javax.swing.JDialog;
import org.rosuda.JGR.layout.AnchorConstraint;
import org.rosuda.JGR.layout.AnchorLayout;
import org.rosuda.REngine.REXP;
import org.rosuda.deducer.Deducer;
import org.rosuda.deducer.WindowTracker;
import org.rosuda.deducer.toolkit.HelpButton;
import org.rosuda.deducer.toolkit.OkayCancelPanel;
import org.rosuda.deducer.widgets.DeducerWidget;

public class RDialog
extends JDialog {
    protected Vector widgets = new Vector();
    protected Vector components = new Vector();
    protected HashMap models;
    protected RDialog parent;
    protected Vector children = new Vector();
    protected OkayCancelPanel okayCancelPanel;
    protected HelpButton helpButton;

    public RDialog() {
        this.init(null);
        this.initGUI();
    }

    public RDialog(Dialog dialog) {
        super(dialog);
        this.init(dialog);
        this.initGUI();
    }

    public RDialog(Dialog dialog, boolean bl) {
        super(dialog, bl);
        this.init(dialog);
        this.initGUI();
    }

    public RDialog(Dialog dialog, String string) {
        super(dialog, string);
        this.init(dialog);
        this.initGUI();
    }

    public RDialog(Dialog dialog, String string, boolean bl) {
        super(dialog, string, bl);
        this.init(dialog);
        this.initGUI();
    }

    public RDialog(Dialog dialog, String string, boolean bl, GraphicsConfiguration graphicsConfiguration) {
        super(dialog, string, bl, graphicsConfiguration);
        this.init(dialog);
        this.initGUI();
    }

    public RDialog(Frame frame) {
        super(frame);
        this.init(frame);
        this.initGUI();
    }

    public RDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.init(frame);
        this.initGUI();
    }

    public RDialog(Frame frame, String string) {
        super(frame, string);
        this.init(frame);
        this.initGUI();
    }

    public RDialog(Frame frame, String string, boolean bl) {
        super(frame, string, bl);
        this.init(frame);
        this.initGUI();
    }

    public RDialog(Frame frame, String string, boolean bl, GraphicsConfiguration graphicsConfiguration) {
        super(frame, string, bl, graphicsConfiguration);
        this.init(frame);
        this.initGUI();
    }

    public Component add(Component component) {
        this.track(component);
        return super.add(component);
    }

    public Component add(Component component, int n) {
        this.track(component);
        if (this.parent != null) {
            this.parent.track(component);
        }
        return super.add(component, n);
    }

    public void add(Component component, Object object) {
        this.track(component);
        if (this.parent != null) {
            this.parent.track(component);
        }
        super.add(component, object);
    }

    public void add(Component component, Object object, int n) {
        this.track(component);
        if (this.parent != null) {
            this.parent.track(component);
        }
        super.add(component, object, n);
    }

    public Component add(String string, Component component) {
        this.track(component);
        if (this.parent != null) {
            this.parent.track(component);
        }
        return super.add(string, component);
    }

    public void remove(Component component) {
        super.remove(component);
        this.untrack(component);
        if (this.parent != null) {
            this.parent.untrack(component);
        }
    }

    public void remove(int n) {
        Component component = this.getComponent(n);
        this.untrack(component);
        if (this.parent != null) {
            this.parent.untrack(component);
        }
        super.remove(n);
    }

    public void removeAll() {
        super.removeAll();
        this.components.removeAllElements();
        this.widgets.removeAllElements();
    }

    protected void init(Component component) {
        if (this.widgets == null) {
            this.widgets = new Vector();
        }
        if (this.components == null) {
            this.components = new Vector();
        }
        if (this.models == null) {
            this.models = new HashMap();
        }
        if (component instanceof RDialog) {
            this.parent = (RDialog)component;
            this.parent.addSubDialog(this);
        } else {
            this.parent = null;
        }
    }

    public void initGUI() {
        AnchorLayout anchorLayout = new AnchorLayout();
        this.setLayout((LayoutManager)anchorLayout);
        this.setSize(555, 645);
    }

    public void addHelpButton(String string) {
        if (this.helpButton != null) {
            this.remove(this.helpButton);
        }
        this.helpButton = new HelpButton(string);
        this.add((Component)this.helpButton, new AnchorConstraint(940, 77, 980, 23, 0, 0, 1, 1));
        this.helpButton.setPreferredSize(new Dimension(32, 32));
    }

    public HelpButton getHelpButton() {
        return this.helpButton;
    }

    public void setOkayCancel(boolean bl, boolean bl2, ActionListener actionListener) {
        if (this.okayCancelPanel != null) {
            this.remove(this.okayCancelPanel);
        }
        this.okayCancelPanel = new OkayCancelPanel(bl, bl2, actionListener);
        this.add((Component)this.okayCancelPanel, new AnchorConstraint(926, 978, 980, 402, 0, 1, 1, 0));
        this.okayCancelPanel.setPreferredSize(new Dimension(307, 32));
    }

    public OkayCancelPanel getOkayCancel() {
        return this.okayCancelPanel;
    }

    public void setToLast() {
        for (int i = 0; i < this.widgets.size(); ++i) {
            ((DeducerWidget)this.widgets.get(i)).resetToLast();
        }
    }

    public void reset() {
        int n;
        for (n = 0; n < this.widgets.size(); ++n) {
            ((DeducerWidget)this.widgets.get(n)).reset();
        }
        for (n = 0; n < this.children.size(); ++n) {
            ((RDialog)this.children.get(n)).reset();
        }
        this.models = new HashMap();
    }

    public void completed() {
        for (int i = 0; i < this.widgets.size(); ++i) {
            DeducerWidget deducerWidget = (DeducerWidget)this.widgets.get(i);
            if (this.parent == null) {
                deducerWidget.setLastModel(deducerWidget.getModel());
                continue;
            }
            this.models.put(deducerWidget, deducerWidget.getModel());
        }
    }

    public void setHelpWikiPage(String string) {
        this.helpButton.setUrl(string);
    }

    public void setHelpVisible(boolean bl) {
        this.helpButton.setVisible(bl);
    }

    public void setOkayCancelVisible(boolean bl) {
        this.okayCancelPanel.setVisible(bl);
    }

    public String getWidgetStatesAsString() {
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < this.widgets.size(); ++i) {
            DeducerWidget deducerWidget = (DeducerWidget)this.widgets.get(i);
            vector.add("\n'" + deducerWidget.getTitle() + "'=" + deducerWidget.getRModel());
        }
        String string = Deducer.makeRCollection(vector, "list", false);
        return string;
    }

    public REXP getWidgetStates() {
        return Deducer.eval(this.getWidgetStatesAsString());
    }

    public void add(Component component, int n, int n2, int n3, int n4, String string, String string2, String string3, String string4) {
        int n5;
        int n6;
        int n7;
        int n8 = string.equals("REL") ? 1 : (n7 = string.equals("ABS") ? 2 : 0);
        int n9 = string2.equals("REL") ? 1 : (n6 = string2.equals("ABS") ? 2 : 0);
        int n10 = string3.equals("REL") ? 1 : (n5 = string3.equals("ABS") ? 2 : 0);
        int n11 = string4.equals("REL") ? 1 : (string4.equals("ABS") ? 2 : 0);
        AnchorConstraint anchorConstraint = new AnchorConstraint(n, n2, n3, n4, n7, n6, n5, n11);
        this.add(component, anchorConstraint);
    }

    public void track(Component component) {
        if (this.widgets == null) {
            this.widgets = new Vector();
        }
        if (this.components == null) {
            this.components = new Vector();
        }
        if (component instanceof DeducerWidget) {
            this.trackWidget((DeducerWidget)((Object)component));
        } else if (!this.components.contains(component)) {
            this.components.add(component);
        }
        if (this.parent != null) {
            this.parent.track(component);
        }
    }

    public boolean untrack(Component component) {
        boolean bl;
        if (this.widgets == null) {
            this.widgets = new Vector();
        }
        if (this.components == null) {
            this.components = new Vector();
        }
        boolean bl2 = bl = this.widgets.remove(component);
        if (!bl) {
            bl2 = this.components.remove(component);
        }
        if (bl2 && this.parent != null) {
            this.parent.untrack(component);
        }
        return bl2;
    }

    public void trackWidget(DeducerWidget deducerWidget) {
        if (!this.widgets.contains(deducerWidget)) {
            this.widgets.add(deducerWidget);
        }
    }

    public boolean untrackWidget(DeducerWidget deducerWidget) {
        return this.widgets.remove(deducerWidget);
    }

    public void addSubDialog(RDialog rDialog) {
        if (!this.children.contains(rDialog)) {
            this.children.add(rDialog);
        }
    }

    protected void clearWorkingModels() {
        this.models = new HashMap();
        for (int i = 0; i < this.children.size(); ++i) {
            ((RDialog)this.children.get(i)).clearWorkingModels();
        }
    }

    public boolean removeSubDialog(RDialog rDialog) {
        return this.children.remove(rDialog);
    }

    public void run() {
        if (this.parent == null) {
            this.setToLast();
        } else {
            for (int i = 0; i < this.widgets.size(); ++i) {
                DeducerWidget deducerWidget = (DeducerWidget)this.widgets.get(i);
                Object v = this.models.get(deducerWidget);
                if (v == null) continue;
                deducerWidget.setModel(v);
            }
        }
        this.setVisible(true);
        if (!Deducer.isJGR()) {
            WindowTracker.addWindow(this);
            if (this.parent == null) {
                WindowTracker.waitForAllClosed();
            }
        }
    }
}

