% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.gic.DMR.R
\name{coef.gic.DMR}
\alias{coef.gic.DMR}
\title{coef.gic.DMR}
\usage{
\method{coef}{gic.DMR}(object, ...)
}
\arguments{
\item{object}{Fitted gic.DMR object.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Vector of coefficients.
}
\description{
Extracts coefficients from a gic.DMR object (for the model with minimal gic).
}
\details{
Similar to other coef methods, this function extracts coefficients from a fitted gic.DMR object for the model with minimal gic.
}
\examples{
data(miete)
y <- miete[,1]
X <- miete[,-1]
m <- DMR(X, y)
g <- gic.DMR(m, c = 2.5)
coef(g)
}

