% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coef.cv.DMR.R
\name{coef.cv.DMR}
\alias{coef.cv.DMR}
\title{coef.cv.DMR}
\usage{
\method{coef}{cv.DMR}(object, ...)
}
\arguments{
\item{object}{Fitted cv.DMR object.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
Vector of coefficients.
}
\description{
Extracts coefficients from a cv.DMR object (for the model with minimal cross-validated error).
}
\details{
Similar to other coef methods, this function extracts coefficients from a fitted cv.DMR object for the model with minimal cross-validated error.
}
\examples{
## cv.DMR for linear regression
set.seed(13)
data(miete)
y <- miete$rent
X <- miete$area
cv = cv.DMR(X,y)
coef(cv)

}

