% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_config.R
\name{get_config}
\alias{get_config}
\title{get_config helper function}
\usage{
get_config(config_file, config_key, logfile_dir, headless)
}
\arguments{
\item{config_file}{A character string. The path to the config.yml-file
containing the database configuration.}

\item{config_key}{A character string. The name of the corresponding
database. This string must be conform with the corresponding config
section in the config.yml-file.}

\item{logfile_dir}{(Optional, String, default: "tempdir()")
The absolute path to folder where the logfile will be stored.}

\item{headless}{(Optional, Boolean, default: TRUE)
Indicating, if the function is run only in the console (headless = TRUE)
or on a GUI frontend (headless = FALSE).}
}
\value{
If successful it returns the config, Null otherwise.
}
\description{
Internal function to read config files
}
\examples{
\donttest{
utils_path <- tempdir()
config <- get_config(
  config_file = paste0(utils_path, "/MISC/email.yml"),
  config_key = "email",
  logfile_dir = tempdir(),
  headless = TRUE
)}

}
