% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geometry.R
\name{row.disc}
\alias{row.disc}
\title{row-wise distribution of points in a disc}
\usage{
row.disc(n)
}
\arguments{
\item{n}{number of points}
}
\value{
data.frame of x and y positions
}
\description{
row-wise distribution of points in a disc
}
\examples{
par(mfrow=c(2,2), mai=c(0, 0, 0.5, 0))
for (n in sample(500, 4)) {
  ret=row.disc(n)
  plot(cos(seq(0, 2 * pi, length.out=7)) * 1.154701,
       sin(seq(0, 2 * pi, length.out=7)) * 1.154701,
       type="l", axes = FALSE, ylab = "", xlab="", main=n)
  points(ret)
}
}
