% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_b1.R
\name{sim_b1}
\alias{sim_b1}
\title{sim_R1.R}
\usage{
sim_b1(lower = TRUE, upper = TRUE, n, muVec, sigMat, bounds)
}
\arguments{
\item{lower}{Boolean, if true sim lower bound.}

\item{upper}{Boolean, if true sim upper bound.}

\item{n}{Number of simulations.}

\item{muVec}{Mean vector of test statistics under the alternative (assuming it's MVN).}

\item{sigMat}{Covariance matrix of test statistics under the alternative (assuming it's MVN).}

\item{bounds}{A J*1 vector of bounds on the magnitudes of the test statistics, where
the first element is the bound for |Z|_(1) and the last element is the bound for |Z|_(J).}
}
\value{
A list with the elements:
\item{lowerBound}{Lower bound on power.}
\item{upperBound}{Upper bound on power.}
}
\description{
Simulate the probability of falling in the region used for the b1 lower
bound or the b1 upper bound.
}
\examples{
myCov <- matrix(data=0.3, nrow=5, ncol=5)
diag(myCov) <- 1
myBounds <- set_GBJ_bounds(alpha = 0.01, J=5, sig_vec = myCov[lower.tri(myCov)])
sim_b1(n=5000, muVec = c(1, 0, 0, 0, 0), sigMat = myCov, bounds=myBounds)

}
