% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dbIsValid.R
\name{dbIsValid}
\alias{dbIsValid}
\title{Is this DBMS object still valid?}
\usage{
dbIsValid(dbObj, ...)
}
\arguments{
\item{dbObj}{An object inheriting from \linkS4class{DBIObject},
i.e. \linkS4class{DBIDriver}, \linkS4class{DBIConnection},
or a \linkS4class{DBIResult}}

\item{...}{Other arguments to methods.}
}
\value{
\code{dbIsValid()} returns a logical scalar,
\code{TRUE} if the object specified by \code{dbObj} is valid,
\code{FALSE} otherwise.
A \linkS4class{DBIConnection} object is initially valid,
and becomes invalid after disconnecting with \code{\link[=dbDisconnect]{dbDisconnect()}}.
For an invalid connection object (e.g., for some drivers if the object
is saved to a file and then restored), the method also returns \code{FALSE}.
A \linkS4class{DBIResult} object is valid after a call to \code{\link[=dbSendQuery]{dbSendQuery()}},
and stays valid even after all rows have been fetched;
only clearing it with \code{\link[=dbClearResult]{dbClearResult()}} invalidates it.
A \linkS4class{DBIResult} object is also valid after a call to \code{\link[=dbSendStatement]{dbSendStatement()}},
and stays valid after querying the number of rows affected;
only clearing it with \code{\link[=dbClearResult]{dbClearResult()}} invalidates it.
If the connection to the database system is dropped (e.g., due to
connectivity problems, server failure, etc.), \code{dbIsValid()} should return
\code{FALSE}. This is not tested automatically.
}
\description{
This generic tests whether a database object is still valid (i.e. it hasn't
been disconnected or cleared).

\Sexpr[results=rd,stage=render]{DBI:::methods_as_rd("dbIsValid")}
}
\examples{
dbIsValid(RSQLite::SQLite())

con <- dbConnect(RSQLite::SQLite(), ":memory:")
dbIsValid(con)

rs <- dbSendQuery(con, "SELECT 1")
dbIsValid(rs)

dbClearResult(rs)
dbIsValid(rs)

dbDisconnect(con)
dbIsValid(con)
}
\seealso{
Other DBIDriver generics: 
\code{\link{DBIDriver-class}},
\code{\link{dbCanConnect}()},
\code{\link{dbConnect}()},
\code{\link{dbDataType}()},
\code{\link{dbDriver}()},
\code{\link{dbGetInfo}()},
\code{\link{dbIsReadOnly}()},
\code{\link{dbListConnections}()}

Other DBIConnection generics: 
\code{\link{DBIConnection-class}},
\code{\link{dbAppendTable}()},
\code{\link{dbCreateTable}()},
\code{\link{dbDataType}()},
\code{\link{dbDisconnect}()},
\code{\link{dbExecute}()},
\code{\link{dbExistsTable}()},
\code{\link{dbGetException}()},
\code{\link{dbGetInfo}()},
\code{\link{dbGetQuery}()},
\code{\link{dbIsReadOnly}()},
\code{\link{dbListFields}()},
\code{\link{dbListObjects}()},
\code{\link{dbListResults}()},
\code{\link{dbListTables}()},
\code{\link{dbReadTable}()},
\code{\link{dbRemoveTable}()},
\code{\link{dbSendQuery}()},
\code{\link{dbSendStatement}()},
\code{\link{dbWriteTable}()}

Other DBIResult generics: 
\code{\link{DBIResult-class}},
\code{\link{dbBind}()},
\code{\link{dbClearResult}()},
\code{\link{dbColumnInfo}()},
\code{\link{dbFetch}()},
\code{\link{dbGetInfo}()},
\code{\link{dbGetRowCount}()},
\code{\link{dbGetRowsAffected}()},
\code{\link{dbGetStatement}()},
\code{\link{dbHasCompleted}()},
\code{\link{dbIsReadOnly}()},
\code{\link{dbQuoteIdentifier}()},
\code{\link{dbQuoteLiteral}()},
\code{\link{dbQuoteString}()},
\code{\link{dbUnquoteIdentifier}()}
}
\concept{DBIConnection generics}
\concept{DBIDriver generics}
\concept{DBIResult generics}
