% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CytOpT.R
\name{CytOpT}
\alias{CytOpT}
\title{Function to estimate the type cell proportions in an unclassified cytometry data set denoted X_s
by using the classification Lab_source from an other cytometry data set X_s. With this function
the computation of the estimate of the class proportions is done with a descent ascent or minmax
or two algorithms.}
\usage{
CytOpT(
  X_s,
  X_t,
  Lab_source,
  Lab_target = NULL,
  theta_true = NULL,
  method = c("minmax", "desasc", "both"),
  eps = 1e-04,
  n_iter = 10000,
  power = 0.99,
  step_grad = 10,
  step = 5,
  lbd = 1e-04,
  n_out = 5000,
  n_stoc = 10,
  minMaxScaler = TRUE,
  monitoring = FALSE,
  thresholding = TRUE
)
}
\arguments{
\item{X_s}{a cytometry dataframe with only \code{d} numerical variables for \code{ns} observations.
The columns correspond to the different biological markers measured.
One line corresponds to the cytometry measurements performed on one cell. The classification
of this Cytometry data set must be provided with the Lab_source parameters.}

\item{X_t}{a cytometry dataframe with only \code{d} numerical variables for \code{nt} observations.
The columns correspond to the different biological markers measured.
One line corresponds to the cytometry measurements performed on one cell. The CytOpT algorithm
targets the cell type proportion in this Cytometry data set}

\item{Lab_source}{a vector of length \code{ns} Classification of the X_s cytometry data set}

\item{Lab_target}{a vector of length \code{nt} Classification of the X_t cytometry data set}

\item{theta_true}{If available, gold-standard proportions in the target data
set \code{X_t} derived from manual gating. It allows to assess the gap between
the estimate and the gold-standard. Default is \code{NULL}, in which case no
assessment is performed.}

\item{method}{a character string indicating which method to use to
compute the cytopt, either \code{'minmax'}, \code{'desasc'}
or  \code{'both'} for comparing both Min-max swapping and descent-ascent procedures.
Default is \code{'minmax'}.}

\item{eps}{a float value of regularization parameter of the Wasserstein distance. Default is \code{1e-04}}

\item{n_iter}{an integer Constant that iterate method select. Default is \code{10000}}

\item{power}{a float constant the step size policy of the gradient ascent method is step/n^power. Default is \code{0.99}}

\item{step_grad}{an integer number step size of the gradient descent algorithm of the outer loop.
Default is \code{10}}

\item{step}{an integer constant that multiply the step-size policy. Default is \code{5}}

\item{lbd}{a float constant that multiply the step-size policy. Default is \code{1e-04}}

\item{n_out}{an integer number of iterations in the outer loop. This loop corresponds to the gradient
descent algorithm to minimize the regularized Wasserstein distance between the source and
target data sets. Default is \code{1000}}

\item{n_stoc}{an integer number of iterations in the inner loop. This loop corresponds to the stochastic
algorithm that approximates a maximizer of the semi dual problem. Default is \code{10}}

\item{minMaxScaler}{a logical flag indicating to whether to scale observations
between 0 and 1. Default is \code{TRUE}.}

\item{monitoring}{a logical flag indicating to possibly monitor the gap between the estimated proportions and the manual
gold-standard. Default is \code{FALSE}.}

\item{thresholding}{a logical flag indicating whether to threshold negative
values.  Default is \code{TRUE}.}
}
\value{
a object of class \code{CytOpt}, which is a list of two elements:\itemize{
  \item \code{proportions} a \code{data.frame} with the (optionally true and)
  estimated proportions for each \code{method}
  \item \code{monitoring} a list of estimates over the optimization iterations
  for each \code{method} (listed within)
}
}
\description{
Function to estimate the type cell proportions in an unclassified cytometry data set denoted X_s
by using the classification Lab_source from an other cytometry data set X_s. With this function
the computation of the estimate of the class proportions is done with a descent ascent or minmax
or two algorithms.
}
\examples{
if(interactive()){

res <- CytOpT(X_s = HIPC_Stanford_1228_1A, X_t = HIPC_Stanford_1369_1A,
             Lab_source = HIPC_Stanford_1228_1A_labels,
             method='minmax')
summary(res)
plot(res)

}
}
