% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{prune_zero_tail}
\alias{prune_zero_tail}
\title{Prune tail made of zeros}
\usage{
prune_zero_tail(diag_mat)
}
\arguments{
\item{diag_mat}{a diagonal matrix which must satisfy the following
property: in the diagonal, every element after a zero is a zero.}
}
\value{
a diagonal matrix without zeros in the diagonal, composed by the
  first rows and columns of the original matrix with non zeros in the
  diagonal (which are also the only ones)
}
\description{
Given a diagonal matrix which is supposed to have no non-zero entry in
the diagonal after the first one (if any) the  function returns the
diagonal (sub-)matrix without the columns and the row corresponding to
the zero-entries in the diagonal (if any).
}
\examples{
diag_mat <- diag(c(1, 2, 3, 0, 0, 0, 0))
prune_zero_tail(diag_mat)
}
