% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Merton.R
\name{Merton}
\alias{Merton}
\title{Merton's model}
\usage{
Merton(L, V0, sigma, r, t)
}
\arguments{
\item{L}{debt face value at maturity \code{t = T}; if the value of
the firm \eqn{V_T} is below the debt face value to be paid in \eqn{T} the
company default has occurred (it is a constant value).}

\item{V0}{firm value at time \code{t = 0} (it is a constant value).}

\item{sigma}{volatility (constant for all t).}

\item{r}{risk-free rate (constant for all t).}

\item{t}{a vector of debt maturity structure. The last value of this
vector rapresents the debt maturity T.}
}
\value{
\code{Merton} returns an object of class \code{data.frame} with:
\itemize{
    \item \code{Vt}: expected Firm value at time \eqn{t < T} calculated by the simple formula
    \eqn{V_t = V_0 * \exp^{r * t}}.
    \item \code{St}: firm equity value at each \eqn{t < T}. This value can be seen as a call
    option on the firm value \code{V_t}.
    \item \code{Dt}: firm debt value at each \eqn{t < T}.
    \item \code{Survival}: surviaval probability for each maturity.
}
}
\description{
\code{Merton} calculates the survival probability \eqn{Q(\tau > T)} for
each maturity according to the structural Merton's model.
}
\details{
In Merton's model the default event can occur only at debt maturity T and not before.
In this model the debt face value \code{L} represents the constant safety
level. In this model the firm value is the sum of the firm equity value \code{St} and
ad the firm debt value \code{Dt}. The debt value at time \eqn{t < T} is calculated by the formula:
\deqn{D_t = L * \exp^{- r * (T - t)} - Put(t, T; V_t, L)}
The equity value can be derived as a difference between the firm value and the debt:
\deqn{S_t = V_t - D_t = V_t - L * \exp^{- r * (T - t)} + Put(t, T; V_t, L) = Call(t, T; V_t, L)}
(by the put-call parity) so that in the Merton's model the equity can be interpreted as a
Call option on the value of the firm.
}
\examples{
mod <- Merton(L = 10, V0 = 20, sigma = 0.2, r = 0.005,
              t = c(0.50, 1.00, 2.00, 3.25, 5.00, 10.00, 15.00, 20.00))
mod

plot(c(0.50, 1.00, 2.00, 3.25, 5.00, 10.00, 15.00, 20.00), mod$Surv,
     main = 'Survival Probability for different Maturity \\n (Merton model)',
     xlab = 'Maturity', ylab = 'Survival Probability', type = 'b')
}
\references{
Damiano Brigo, Massimo Morini, Andrea Pallavicini (2013)
Counterparty Credit Risk, Collateral and Funding.
With Pricing Cases for All Asset Classes
}
