% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/at1p.R
\name{at1p}
\alias{at1p}
\title{Analytically - Tractable First Passage (AT1P) model}
\usage{
at1p(V0, H0, B, sigma, r, t)
}
\arguments{
\item{V0}{firm value at time \code{t = 0} (it is a constant value).}

\item{H0}{value of the safety level at time \code{t = 0}.}

\item{B}{free positive parameter used for shaping the barrier \code{Ht}.}

\item{sigma}{a vector of constant stepwise volatility \eqn{\sigma_t}.}

\item{r}{a vector of constant stepwise risk-free rate.}

\item{t}{a vector of debt maturity structure (it is a numeric vector).}
}
\value{
\code{at1p} returns an object of class \code{data.frame} containing the firm value, safety level \eqn{H(t)}
and the survival probability for each maturity. The last column is the default intensity calculated
among each interval \eqn{\Delta t}.
}
\description{
\code{at1p} calculates the survival probability \eqn{Q(\tau > t)} and default intensity
for each maturity according to the structural Analytically - Tractable First Passage model.
}
\details{
In this function the safety level \code{Ht} is calculated using the formula:
\deqn{H(t) = \frac{H0}{V0} * E_0[V_t] * \exp^{- B \int_0^t \sigma_u du}}
The backbone of the default barrier at \eqn{t} is a proportion, controlled by the parameter
\code{H0}, of the expected value of the company assets at \eqn{t}. \code{H0} may depend on the
level of the liabilities, on safety covenants, and in general on the characteristics of the capital
structure of the company. Also, depending on the value of the parameter \code{B}, it is possible
that this backbone is modified by accounting for the volatility of the company assets. For
example, if \code{B > 0} corresponds to the interpretation that when volatility increases - which
can be independed of credit quality - the barrier is slightly lowered to cut some more slack
to the company before going bankrupt. When \code{B = 0} the barrier does not depend on the
volatility and the "distance to default" is simply modelled through the barrier parameter \code{H0}.
}
\examples{
mod <- at1p(V0 = 1, H0 = 0.7, B = 0.4, sigma = rep(0.1, 10), r = cdsdata$ED.Zero.Curve,
t = cdsdata$Maturity)
mod

plot(cdsdata$Maturity, mod$Ht, type = 'b', xlab = 'Maturity', ylab = 'Safety Level H(t)',
main = 'Safety level for different maturities', ylim = c(min(mod$Ht), 1.5),
col = 'red')
lines(cdsdata$Maturity, mod$Vt, xlab = 'Maturity', ylab = 'V(t)',
main = 'Value of the Firm \\n at time t', type = 's')

plot(cdsdata$Maturity, mod$Survival, type = 'b',
main = 'Survival Probability for different Maturity \\n (AT1P model)',
xlab = 'Maturity', ylab = 'Survival Probability')

matplot(cdsdata$Maturity, mod$Default.Intensity, type = 'l', xlab = 'Maturity',
ylab = 'Default Intensity')

}
\references{
Damiano Brigo, Massimo Morini, Andrea Pallavicini (2013)
Counterparty Credit Risk, Collateral and Funding.
With Pricing Cases for All Asset Classes.
}
