% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotROCcurveTri.R
\name{plotROCcurveTri}
\alias{plotROCcurveTri}
\title{Plotting of ROC Curves for Trichotomous Biomarkers}
\usage{
plotROCcurveTri(Plat0, Plat2, P0, P2, rho)
}
\arguments{
\item{Plat0}{a numeric value specifying the prevalence of the latent lower protected subgroup for a dichotomous or trichotomous biomarker}

\item{Plat2}{a numeric vector of length four specifying the prevalences of the latent higher protected subgroup for a dichotomous or trichotomous biomarker}

\item{P0}{a numeric vector specifying a grid of probabilities of low biomarker response for a dichotomous or trichotomous biomarker.}

\item{P2}{a numeric vector specifying a grid of probabilities of high biomarker response for a dichotomous or trichotomous biomarker.}

\item{rho}{a numeric vector of length four specifying distinct protection-relevant fractions of \code{sigma2obs}.}
}
\value{
None. The function is called solely for plot generation.
}
\description{
Plots the receiver operating characteristic (ROC) curve displaying sensitivity and specificity for a range of \code{P2} and \code{P0} values,
four values of \code{rho}, and four values of \code{Plat2}. Illustrates how different levels of measurement error \code{rho} map to sensitivity
and specificity, depending on the value of \code{Plat2}. This funciton is used to create Figure 1 in the Supplementary Material of
[Gilbert, Janes, and Huang (2016). "Power/Sample Size Calculations for Assessing Correlates of Risk in Clinical Efficacy Trials."]
}
\examples{
Plat0 <- 0.2
Plat2 <- c(0.2, 0.3, 0.4, 0.5)
P0 <- seq(0.90, 0.10, len=10)
P2 <- seq(0.10, 0.90, len=10)
rho <- c(1, 0.9, 0.7, 0.5)
plotROCcurveTri(Plat0 = Plat0, Plat2 = Plat2, P0 = P0, P2 = P2, rho = rho)

}
