% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Missing_simulation.R
\name{miss_sim}
\alias{miss_sim}
\title{Simulation of missings}
\usage{
miss_sim(dat, p = 0.2, type = "MAR", seed_nr = 123)
}
\arguments{
\item{dat}{Data frame with only numeric values}

\item{p}{Fraction of missings (for entire data frame)}

\item{type}{Type of missingness. Either MCAR (=missing completely at random) or MAR (=missing at random)}

\item{seed_nr}{Number for set.seed()}
}
\value{
data frame with only numeric values and NAs
}
\description{
Simulates missing at random using a normal copula to create correlations between the missing (type="MAR").
Missings appear in each column of the provided data frame with the same ratio.
}
\examples{
data(cars)
cars_with_missings <- miss_sim(cars,p = .2,seed_nr = 4)
summary(cars_with_missings)

}
