% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indecis_indices.R
\name{utci}
\alias{utci}
\title{Universal Thermal Climate Index}
\usage{
utci(ta, rh, wind, tmrt, data_names = NULL, time.scale = YEAR,
  na.rm = FALSE)
}
\arguments{
\item{ta}{medium temperature}

\item{rh}{humidity}

\item{wind}{average wind}

\item{tmrt}{radiation temperature}

\item{data_names}{names of each period of time}

\item{time.scale}{month, season or year}

\item{na.rm}{logical. Should missing values (including NaN) be removed?}
}
\value{
UTCI
}
\description{
The Universal Thermal Climate Index is expressed as an equivalent ambient temperature (Celsius) of a reference environment providing the same physiological response of a reference person as the actual environment
\url{http://www.utci.org/} http://www.utci.org/utci_doku.php
Copy \url{https://github.com/alfcrisci/rBiometeo}
Given air temperature (Celsius), relative humidity (\%), wind velocity (m/sec) and mean radiant temperature ( tmrt in Celsius degree) gives the Universal Thermal Climate Index in Celsius.
}
\examples{
data(data_all)
utci(ta = data_all$tg, rh = data_all$dewpoint, wind = data_all$wind, 
     tmrt = data_all$"RADIATIONTEMPERATURE")
}
\references{
Blazejczyk, K., Epstein, Y., Jendritzky, G., Staiger, H., & Tinz, B. (2012). Comparison of UTCI to selected thermal indices. International Journal of Biometeorology, 56(3), 515-535. doi:10.1007/s00484-011-0453-2
}
