% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indecis_indices.R
\name{tci}
\alias{tci}
\title{Tourism Climatic Index}
\usage{
tci(data, sunshine, w, data_names = NULL, time.scale = YEAR,
  na.rm = FALSE)
}
\arguments{
\item{data}{precipitation}

\item{sunshine}{net radiation}

\item{w}{average wind}

\item{data_names}{names of each period of time}

\item{time.scale}{month, season or year}

\item{na.rm}{logical. Should missing values (including NaN) be removed?}
}
\value{
TCI
}
\description{
Standard index computed by ECA&D; Described at Miezkowski (1985), conceptual formula: TCI = 4cid + cia + 2R + 2S + W, where CId is a daytime comfort index, CIa a daily comfort index, R is cumulated rainfall, S the daily sunshine hours and W wind speed
Represents a quantitative evaluation of world climate for the purposes of tourism and is a composite measure of the climatic well-being of tourists.
TCI = 4cid + cia + 2R + 2S + W, where CId is a daytime comfort index, CIa a daily comfort index, R is cumulated rainfall, S the daily sunshine hours and W wind speed
}
\examples{
data(data_all)
tci(data=data_all$rr, sunshine=radiation.value, w=w.value)
}
\references{
Mieczkowski, Z. (1985). The tourism climatic index: a method of evaluating world climates for tourism. The Canadian Geographer/Le Géographe canadien, 29(3), 220-233.
}
