% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indecis_indices.R
\name{ffdi}
\alias{ffdi}
\title{McArthur Forest Fire Danger Index}
\usage{
ffdi(taverage, pr, rh, w, data_names = NULL, time.scale = YEAR,
  na.rm = FALSE)
}
\arguments{
\item{taverage}{medium temperature}

\item{pr}{precipitation}

\item{rh}{relative humidity}

\item{w}{average wind}

\item{data_names}{names of each period of time}

\item{time.scale}{month, season or year}

\item{na.rm}{logical. Should missing values (including NaN) be removed?}
}
\value{
FFDI
}
\description{
The McArthur Forest Fire Danger Index (FFDI) is a good indication of the difficulty of fire suppression over a wide range of conditions. It estimates the amount of precipitation needed to bring the soil back to saturation and is computed from the Keetch-Byram Drought Index (KBDI) and Drought Factor (DF).
}
\examples{
data(data_all)
ffdi(taverage = data_all$tg, pr=data_all$rr, rh=data_all$humidity, w=data_all$wind)
}
\references{
McArthur, A. G. (1967). Fire behaviour in eucalypt forests. Forestry and Timber Bureau Leaflet 107, 36 pp.
}
