% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indecis_indices.R
\name{cd}
\alias{cd}
\title{Percentage of cold days}
\usage{
cd(data, data_names = NULL, time.scale = YEAR, na.rm = FALSE)
}
\arguments{
\item{data}{maximum temperature}

\item{data_names}{names of each period of time}

\item{time.scale}{month, season or year}

\item{na.rm}{logical. Should missing values (including NaN) be removed?}
}
\value{
percentage of cold days
}
\description{
Percentages of days with TX lower than the 10th percentile.
}
\section{Formula}{
 \deqn{cd = \frac{No. days TX < 10p} {No. days} * 100}
}

\examples{
data(data_all)
cd(data=data_all$tx)
}
