% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcaDiag.R
\name{pcaDiag}
\alias{pcaDiag}
\title{Outlier Diagnostic Plots for PCA of a Spectra Object}
\usage{
pcaDiag(
  spectra,
  pca,
  pcs = 3,
  quantile = 0.975,
  plot = c("OD", "SD"),
  use.sym = FALSE,
  ...
)
}
\arguments{
\item{spectra}{An object of S3 class \code{\link{Spectra}}.}

\item{pca}{An object of class \code{\link{prcomp}}
modified to include a character string (\code{$method}) describing the
pre-processing carried out and the type of PCA performed.}

\item{pcs}{As per \code{\link[chemometrics]{pcaDiagplot}}.  The number of
principal components to include.}

\item{quantile}{As per \code{\link[chemometrics]{pcaDiagplot}}.  The
significance criteria to use as a cutoff.}

\item{plot}{A character string, indicating whether to plot the score
distances or orthogonal distances, or both.  Options are \code{c("OD",
"SD")}.}

\item{use.sym}{logical; if true, the color scheme is change to black and
symbols are used for plotting.}

\item{\dots}{Parameters to be passed to the plotting routines. \emph{Applies to base graphics only}.}
}
\value{
The returned value depends on the graphics option selected (see \code{\link{GraphicsOptions}}).
\describe{
 \item{base:}{A data frame or list containing the data plotted.  Assign the value and run \code{str()}
              or \code{names()} on it to see what it contains. Side effect is a plot.}
 \item{ggplot2:}{The plot is displayed, and a \code{ggplot2} plot object is returned if the
                 value is assigned. The plot can be modified in the usual \code{ggplot2} manner.
                 If you want the plotted values, you can access them via the base graphics mode.}
}
}
\description{
A function to carry diagnostics on the PCA results for a
\code{\link{Spectra}} object.  Basically a wrapper to Filzmoser's
\code{\link[chemometrics]{pcaDiagplot}} which colors everything according to
the scheme stored in the \code{\link{Spectra}} object.  Works with PCA
results of either class \code{prcomp} or class \code{princomp}.  Works
with either classical or robust PCA results.
}
\details{
If both plots are desired, the output should be directed to a file rather
than the screen.  Otherwise, the 2nd plot overwrites the 1st in the active
graphics window.  Alternatively, just call the function twice, once
specifying \code{OD} and once specifying \code{SD}.
}
\examples{
# This example assumes the graphics output is set to ggplot2 (see ?GraphicsOptions).
library("ggplot2")
data(SrE.IR)
pca <- c_pcaSpectra(SrE.IR, choice = "noscale")
p1 <- pcaDiag(SrE.IR, pca, pcs = 2, plot = "OD") + ggtitle("OD Plot")
p1
p2 <- pcaDiag(SrE.IR, pca, pcs = 2, plot = "SD") + ggtitle("SD Plot")
p2

}
\references{
K. Varmuza and P. Filzmoser \emph{Introduction to Multivariate
Statistical Analysis in Chemometrics}, CRC Press, 2009.
}
\seealso{
\code{\link[chemometrics]{pcaDiagplot}} in package
\code{chemometrics} for the underlying function. Additional documentation at
\url{https://bryanhanson.github.io/ChemoSpec/}
}
\author{
Bryan A. Hanson (DePauw University), Tejasvi Gupta.
}
\keyword{multivariate}
