% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions.R
\name{kernel.fun}
\alias{kernel.fun}
\title{Generates covariances matrices thanks to \code{\link{Kernel.class}}}
\usage{
kernel.fun(X, var, psi, kernel.type = "gauss")
}
\arguments{
\item{X}{data}

\item{var}{the variance for the covariance function}

\item{psi}{the parameter vector}

\item{kernel.type}{the choice of the form of the kernel (with d chosen as an euclidian distance) \itemize{
\item{gauss}{ \deqn{\sigma^2 exp{-1/2(d/\psi)^2}}}
\item{exp}{ \deqn{\sigma^2 exp{-1/2 d/\psi}}}
\item{matern3_2}{ \deqn{\sigma^2(1+\sqrt{3}d^2/\psi) exp{-\sqrt{3}d^2/\psi}}}
\item{matern5_2}{ \deqn{\sigma^2(1+\sqrt{5}d^2/\psi+5d^2/(3\psi^2))exp{-\sqrt{5}d^2/\psi}}}}}
}
\value{
\code{Kernel.fun} returns a covariance matrix
}
\description{
\code{Kernel.fun} is a function that allows us to generate covariances matrices from data
}
\examples{
\dontrun{
X <- cbind(seq(0,10,length.out=10),seq(8,20,length.out=10))
var <- 2
psi <- 0.1
Cov <- kernel.fun(X,var,psi,kernel.type="matern5_2")
}
}
\seealso{
\code{\link{model.class}}, \code{\link{prior.class}}
}
\author{
M. Carmassi
}
