% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize.trends.R
\name{summarize.trends}
\alias{summarize.trends}
\title{Summarize trends in the congruence class}
\usage{
summarize.trends(model_set, threshold = 0.005, rate_name = "lambda", 
window_size = 1, method = "neighbour", per_time = TRUE, return_data = FALSE,
rm_singleton = FALSE, relative_deltas = FALSE, group_names = NULL)
}
\arguments{
\item{model_set}{an object of type "CRABSset"}

\item{threshold}{a threshold for when \eqn{\Delta \lambda i} should be interpreted as decreasing, flat, or increasing}

\item{rate_name}{either "lambda" or "mu" or "delta"}

\item{window_size}{the window size "k" in \eqn{\Delta\lambda i = \lambda i - \lambda(i-k)}}

\item{method}{default to "neighbour", i.e. to compare rate values at neighbouring time points.}

\item{per_time}{whether to compute \eqn{\Delta\lambda i} that are in units of per time, i.e. divide by \eqn{\Delta t}}

\item{return_data}{instead of plots, return the plotting dataframes}

\item{rm_singleton}{whether or not to remove singletons. Pass starting at present, going towards ancient}

\item{relative_deltas}{whether to divide \eqn{\Delta \lambda i} by the local lambda value}

\item{group_names}{a vector of prefixes, if you want to group the models in a facet. For example 'c("reference", "model")'}
}
\value{
a patchwork object
}
\description{
Summarize trends in the congruence class
}
\examples{

data(primates_ebd)
lambda <- approxfun(primates_ebd$time, primates_ebd$lambda)
mu <- approxfun(primates_ebd$time, primates_ebd$mu)
times <- seq(0, max(primates_ebd$time), length.out = 500)

reference <- create.model(lambda, mu, times = times)

mus <- list(function(t) exp(0.01*t) - 0.01*t - 0.9,
            function(t) exp(-0.02*t) - 0.2,
            function(t) exp(-0.07*t) + 0.02*t - 0.5,
            function(t) 0.2 + 0.01*t,
            function(t) 0.2)


model_set <- congruent.models(reference, mus = mus)

p <- summarize.trends(model_set, 0.02)
}
