% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ffa_test_modifier.R
\name{ffa_test_modifier}
\alias{ffa_test_modifier}
\title{Oil Test Modifier}
\source{
DNO Common Network Asset Indices Methodology (CNAIM),
Health & Criticality - Version 1.1, 2017:
\url{https://www.ofgem.gov.uk/system/files/docs/2017/05/dno_common_network_asset_indices_methodology_v1.1.pdf}
}
\usage{
ffa_test_modifier(furfuraldehyde = "Default")
}
\arguments{
\item{furfuraldehyde}{Numeric. Refers to the furfuraldehyde level in the
transformer oil. furfuraldehyde levels are measured in ppm.
A setting of \code{"Default"} will result in the best possible result.}
}
\value{
Data table.
}
\description{
This function calculates the FFA test modifier based on the
levels of furfuraldehyde in the transformer oil. This function applies for
33/10kV, 66/10kV and 132kV transformers. See e.g. section 6.13 on page
67 in CNAIM (2017).
}
\examples{
# FFA test modifier
ffa_test_modifier(furfuraldehyde = 50)
}
