#' summary.CAISEr
#'
#' S3 method for summarizing _CAISEr_ objects (the output of
#' [run_experiment()]).
#'
#' @param object list object of class _CAISEr_
#'                     (generated by [run_experiment()])
#' @param ... other parameters to be passed down to specific
#'            summary functions (currently unused)
#'
#' @examples
#' # Example using dummy algorithms and instances. See ?dummyalgo for details.
#' # In this case all instances are the same, so we expect all cases to return
#' # a percent difference of approx. phi.j = 1.0 and sample sizes of
#' # approx. n1 = 31, n2 = 87
#' algorithm1 <- list(FUN = "dummyalgo", alias = "algo1",
#'                    distribution.fun = "rnorm",
#'                    distribution.pars = list(mean = 10, sd = 1))
#' algorithm2 <- list(FUN = "dummyalgo", alias = "algo2",
#'                    distribution.fun = "rnorm",
#'                    distribution.pars = list(mean = 20, sd = 4))
#' algolist <- list(algorithm1, algorithm2)
#' instlist <- vector(100, mode = "list")
#' for (i in 1:100) instlist[[i]] <- list(FUN = "dummyinstance",
#'                                        alias = paste0("Inst. ", i))
#'
#' out <- run_experiment(Instance.list = instlist,
#'                       Algorithm.list = algolist,
#'                       power = 0.8,
#'                       d = 1,
#'                       sig.level = 0.01,
#'                       se.max = 0.05,
#'                       dif = "perc",
#'                       nmax   = 200,
#'                       seed   = 1234)
#' summary(out)
#'
#' @export
#'
summary.CAISEr <- function(object,
                           ...)
{

  # Error checking
  assertthat::assert_that("CAISEr" %in% class(object))

  # ===========================================================================
  # Print summary
  ninst <- length(object$instances.sampled)

  cat("#====================================")
  cat("\n CAISEr object:")
  cat("\n Number of instances sampled:", ninst)
  cat("\n Number of instances required:", object$N.star)
  cat("\n Adequate power:", !object$Underpowered)
  cat("\n Total number of runs of",
      paste0(unique(object$data.raw$Algorithm)[1], ":"),
      sum(object$data.summary$n1j))
  cat("\n Total number of runs of",
      paste0(unique(object$data.raw$Algorithm)[2], ":"),
      sum(object$data.summary$n2j))
  cat("\n#====================================")
}
