% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/caesar_enrichscore.R
\name{CAESAR.enrich.score}
\alias{CAESAR.enrich.score}
\title{Calculate Spot Level Enrichment Scores for Pathways Using CAESAR}
\usage{
CAESAR.enrich.score(
  seu,
  pathwaylist,
  assay.dist = "distce",
  reduction.name = "caesar",
  gene.use = NULL,
  n_fake = 1001,
  seed = 1
)
}
\arguments{
\item{seu}{A Seurat object containing the gene expression data.}

\item{pathwaylist}{A list of pathways, where each pathway is represented by a vector of genes.}

\item{assay.dist}{A character string specifying the assay that contains the distance matrix. Default is "distce".}

\item{reduction.name}{A character string specifying the reduction method to use if the distance matrix needs to be computed. Default is "caesar".}

\item{gene.use}{A character vector specifying which genes to use in the analysis. If \code{NULL}, all genes in the distance matrix will be used. Default is \code{NULL}.}

\item{n_fake}{An integer specifying the number of random permutations to generate for significance testing. Default is 1001.}

\item{seed}{An integer specifying the random seed for reproducibility. Default is 1.}
}
\value{
A matrix of enrichment scores with cells as rows and pathways as columns.
}
\description{
This function calculates spot level enrichment scores for a list of pathways based on a cell-gene distance matrix in a Seurat object. The function uses a permutation-based approach to determine the significance of the enrichment scores.
}
\examples{
data(toydata)

seu <- toydata$seu
pathway_list <- toydata$pathway_list

enrich.score <- CAESAR.enrich.score(seu, pathway_list)
head(enrich.score)

}
