% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{fvbmpartiald}
\alias{fvbmpartiald}
\title{Partial derivatives of the log-pseudolikelihood function for a fitted fully-visible Boltzmann machine.}
\usage{
fvbmpartiald(data, model)
}
\arguments{
\item{data}{Vector of length n containing binary spin variables.}

\item{model}{List generated from \code{fitfvbm}.}
}
\value{
A list containing 2 objects: a vector containing the partial derivatives corresponding to the bias parameters \code{bvec}, and a matrix containing the partial derivatives corresponding to the interaction parameters \code{Mmat}.
}
\description{
Computes the partial derivatives for all unique parameter elements of the bias vector and interaction matrix of a fully-visible Boltzmann machine, for some random length n string of spin variables (i.e. each element is -1 or 1) and some fitted parameter values.
}
\examples{
# Generate num=1000 random strings of n=3 binary spin variables under bvec and Mmat.
num <- 1000
bvec <- c(0,0.5,0.25)
Mmat <- matrix(0.1,3,3) - diag(0.1,3,3)
data <- rfvbm(num,bvec,Mmat)
# Fit a fully visible Boltzmann machine to data, starting from parameters bvec and Mmat.
model <- fitfvbm(data,bvec,Mmat)
# Compute the partial derivatives evaluated at the first observation of data.
fvbmpartiald(data,model)
}
\references{
H.D. Nguyen and I.A. Wood (2016), Asymptotic normality of the maximum pseudolikelihood estimator for fully-visible Boltzmann machines, IEEE Transactions on Neural Networks and Learning Systems, vol. 27, pp. 897-902.
}
\author{
Andrew T. Jones and Hien D. Nguyen
}
