% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_consensus.R
\name{compute_consensus.BayesMallows}
\alias{compute_consensus.BayesMallows}
\title{Compute Consensus Ranking}
\usage{
\method{compute_consensus}{BayesMallows}(
  model_fit,
  type = "CP",
  burnin = model_fit$burnin,
  parameter = "rho",
  assessors = 1L,
  ...
)
}
\arguments{
\item{model_fit}{Object of type \code{BayesMallows} returned from
\code{\link{compute_mallows}}.}

\item{type}{Character string specifying which consensus to compute. Either
\code{"CP"} or \code{"MAP"}. Defaults to \code{"CP"}.}

\item{burnin}{A numeric value specifying the number of iterations to discard
as burn-in. Defaults to \code{model_fit$burnin}, and must be provided if
\code{model_fit$burnin} does not exist. See
\code{\link{assess_convergence}}.}

\item{parameter}{Character string defining the parameter for which to compute
the consensus. Defaults to \code{"rho"}. Available options are \code{"rho"}
and \code{"Rtilde"}, with the latter giving consensus rankings for
augmented ranks.}

\item{assessors}{When \code{parameter = "rho"}, this integer vector is used
to define the assessors for which to compute the augmented ranking.}

\item{...}{Other arguments passed on to other methods. Currently not used.
Defaults to \code{1L}, which yields augmented rankings for assessor 1.}
}
\description{
Compute Consensus Ranking
}
\seealso{
Other posterior quantities: 
\code{\link{assign_cluster}()},
\code{\link{compute_consensus.SMCMallows}()},
\code{\link{compute_consensus}()},
\code{\link{compute_posterior_intervals.BayesMallows}()},
\code{\link{compute_posterior_intervals.SMCMallows}()},
\code{\link{compute_posterior_intervals}()},
\code{\link{heat_plot}()},
\code{\link{plot.BayesMallows}()},
\code{\link{plot.SMCMallows}()},
\code{\link{plot_elbow}()},
\code{\link{plot_top_k}()},
\code{\link{predict_top_k}()},
\code{\link{print.BayesMallowsMixtures}()},
\code{\link{print.BayesMallows}()}
}
\concept{posterior quantities}
