% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bd.R
\name{bd}
\alias{bd}
\title{Ball Divergence statistic}
\usage{
bd(x, y = NULL, distance = FALSE, size = NULL, num.threads = 1,
  kbd.type = c("sum", "maxsum", "max"))
}
\arguments{
\item{x}{a numeric vector, matrix, data.frame, or a list containing at least two numeric vectors, matrices, or data.frames.}

\item{y}{a numeric vector, matrix, data.frame.}

\item{distance}{if \code{distance = TRUE}, the elements of \code{x} will be considered as a distance matrix. Default: \code{distance = FALSE}.}

\item{size}{a vector recording sample size of each group.}

\item{num.threads}{number of threads. If \code{num.threads = 0}, then all of available cores will be used. Default \code{num.threads = 0}.}

\item{kbd.type}{a character string specifying the \eqn{K}-sample Ball Divergence test statistic, 
must be one of \code{"sum"}, \code{"summax"}, or \code{"max"}. Any unambiguous substring can be given. 
Default \code{kbd.type = "sum"}.}
}
\value{
\item{\code{bd }}{ Ball Divergence statistic}
}
\description{
Compute Ball Divergence statistic, which is a generic dispersion measure in Banach spaces.
}
\details{
Given the samples not containing missing values, \code{bd} returns Ball Divergence statistics.
If we set \code{distance = TRUE}, arguments \code{x}, \code{y} can be a \code{dist} object or a
symmetric numeric matrix recording distance between samples; 
otherwise, these arguments are treated as data.

Ball divergence statistic measure the distribution difference of two datasets in Banach spaces. 
The Ball divergence statistic is proven to be zero if and only if two datasets are identical.

The definition of the Ball Divergence statistics is as follows.
Given two independent samples \eqn{ \{x_{1}, \ldots, x_{n}\} } with the associated probability measure \eqn{\mu} and 
\eqn{ \{y_{1}, \ldots, y_{m}\} } with \eqn{\nu}, where the observations in each sample are \emph{i.i.d}.
Let \eqn{\delta(x,y,z)=I(z\in \bar{B}(x, \rho(x,y)))}, 
where \eqn{\delta(x,y,z)} indicates whether \eqn{z} is located in the closed ball \eqn{\bar{B}(x, \rho(x,y))} 
with center \eqn{x} and radius \eqn{\rho(x, y)}. 
We denote:
\deqn{
A_{ij}^{X}=\frac{1}{n}\sum_{u=1}^{n}{\delta(X_i,X_j,X_u)}, \quad A_{ij}^{Y}=\frac{1}{m}\sum_{v=1}^{m}{\delta(X_i,X_j,Y_v)},
}
\deqn{
C_{kl}^{X}=\frac{1}{n}\sum_{u=1}^{n}{\delta(Y_k,Y_l,X_u)}, \quad C_{kl}^{Y}=\frac{1}{m}\sum_{v=1}^{m}{\delta(Y_k,Y_l,Y_v)}.
}
\eqn{A_{ij}^X} represents the proportion of samples \eqn{ \{x_{1}, \ldots, x_{n}\} } located in the 
ball \eqn{\bar{B}(X_i,\rho(X_i,X_j))} and \eqn{A_{ij}^Y} represents the proportion of samples \eqn{ \{y_{1}, \ldots, y_{m}\} } 
located in the ball \eqn{\bar{B}(X_i,\rho(X_i,X_j))}. 
Meanwhile, \eqn{C_{kl}^X} and \eqn{C_{kl}^Y} represent the corresponding proportions located in the ball \eqn{\bar{B}(Y_k,\rho(Y_k,Y_l))}.
The Ball Divergence statistic is defined as:
\deqn{D_{n,m}=A_{n,m}+C_{n,m}}

Ball Divergence can be generalized to the \emph{K}-sample test problem. Suppose we 
have \eqn{K} group samples, each group include \eqn{n_{k}} samples. 
The definition of \eqn{K}-sample Ball Divergence statistic could be 
to directly sum up the two-sample Ball Divergence statistics of all sample pairs (\code{kbd.type = "sum"})
\deqn{\sum_{1 \leq k < l \leq K}{D_{n_{k},n_{l}}},}
or to find one sample with the largest difference to the others (\code{kbd.type = "maxsum"})
\deqn{\max_{t}{\sum_{s=1, s \neq t}^{K}{D_{n_{s}, n_{t}}},}}
to aggregate the \eqn{K-1} most significant different two-sample Ball Divergence statistics (\code{kbd.type = "max"})
\deqn{\sum_{k=1}^{K-1}{D_{(k)}},}
where \eqn{D_{(1)}, \ldots, D_{(K-1)}} are the largest \eqn{K-1} two-sample Ball Divergence statistics among 
\eqn{\{D_{n_s, n_t}| 1 \leq s < t \leq K\}}. When \eqn{K=2},
the three types of Ball Divergence statistics degenerate into two-sample Ball Divergence statistic.

See \code{\link{bd.test}} for a test of distribution equality based on the Ball Divergence.
}
\examples{
############# Ball Divergence #############
x <- rnorm(50)
y <- rnorm(50)
bd(x, y)
}
\references{
Wenliang Pan, Yuan Tian, Xueqin Wang, Heping Zhang. Ball Divergence: Nonparametric two sample test. Ann. Statist. 46 (2018), no. 3, 1109--1137. doi:10.1214/17-AOS1579. https://projecteuclid.org/euclid.aos/1525313077
}
\seealso{
\code{\link{bd.test}}
}
\author{
Wenliang Pan, Yuan Tian, Xueqin Wang, Heping Zhang
}
