% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/barmorc.R
\name{calculate_aa_prob}
\alias{calculate_aa_prob}
\title{Calculates an amino acid typing probability.}
\usage{
calculate_aa_prob(chi_squared_stat, df = 2)
}
\arguments{
\item{chi_squared_stat}{a single or a vector of chi-squared statistics}

\item{df}{degrees of freedom, default is 2}
}
\value{
Input can be a single value or a vector of values, the output will be probability density for each value.
}
\description{
Function returns the probability (density) for a certain type of amino acid based on a chi-squared statistics with 2 degrees of freedom.
}
\examples{
# Find density for a chi square parameter with 3 degrees of freedom
calculate_aa_prob(0.314, df=3)
# Find density for a list of (chi square statistics) with 2 degrees of freedom
calculate_aa_prob(c(0.05, 0.1, 0.5), 2)
}
