% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RunTime.R
\name{RunTime}
\alias{RunTime}
\title{Compute percentiles of the run timing distribution.}
\usage{
RunTime(time, U, prob = seq(0, 1, 0.1))
}
\arguments{
\item{time}{A numeric vector of time used to label the strata. For example,
this could be julian week for data stratified at a weekly level.}

\item{U}{matrix of posterior samples. Each row is a sample from the posterior.}

\item{prob}{Quantiles of the run timing to estimate.}
}
\value{
An MCMC object with samples from the posterior distribution. A
series of graphs and text file are also created in the working directory.
This information is now added to the fit object as well and so it is unlikely
that you will use this function.
}
\description{
Take the posterior sample of U[1,...nstrata] and compute the percentiles of the run
timing. 
This uses the quantile() function from the "actuar" package which is designed to compute
quantiles of grouped data.
It is assumed that there are no fish in the system prior to the first point
}
\references{
Bonner, S. J., & Schwarz, C. J. (2011). 
Smoothing population size estimates for Time-Stratified Mark-Recapture experiments Using Bayesian P-Splines. 
Biometrics, 67, 1498-1507. 
\doi{10.1111/j.1541-0420.2011.01599.x}

Schwarz, C. J., & Dempson, J. B. (1994).
Mark-recapture estimation of a salmon smolt population. 
Biometrics, 50, 98-108.

Schwarz, C.J., D. Pickard, K. Marine and S.J. Bonner. 2009. Juvenile Salmonid Outmigrant
Monitoring Evaluation, Phase II - December 2009. Final Technical Memorandum for the Trinity River
Restoration Program, Weaverville, CA. 155 pp. + appendices available at
\url{https://www.trrp.net/library/document/?id=369}
}
\author{
Bonner, S.J. \email{sbonner6@uwo.ca} and 
Schwarz, C. J. \email{cschwarz.stat.sfu.ca@gmail.com}.
}
