% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/levelplot2D.R
\name{levelplot2D}
\alias{levelplot2D}
\title{levelplot for 2D images.}
\usage{
levelplot2D(
  S,
  coords,
  lim = c(min(S), max(S)),
  xlim = c(0, max(coords[, 1])),
  ylim = c(0, max(coords[, 2])),
  color = bluered(100),
  layout = c(1, nrow(S)),
  file = NULL
)
}
\arguments{
\item{S}{Data matrix with q rows (sample) and p colums (pixel).}

\item{coords}{Coordinates matrix with p rows (pixel) and 2 columns (dimension), specifying the coordinates of the data points.}

\item{lim}{2-dimensional numeric vector, specifying the limits for the data.}

\item{xlim}{2-dimensional numeric vector, specifying the lower and upper limits of \code{x}.}

\item{ylim}{2-dimensional numeric vector, specifying the lower and upper limits of \code{y}.}

\item{color}{Colorbar.}

\item{layout}{2-dimensional numeric vector, specifying the number of rows and number of columns for the layout of components.}

\item{file}{Name of the file to be saved.}
}
\value{
No return value.
}
\description{
The function plots 2D images for a data matrix.
}
\examples{
sim = sim_2Dimage(length = 30, sigma = 5e-4, n = 30, smooth = 6)
levelplot2D(sim$S,lim = c(-0.04,0.04), sim$coords)

}
