% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sum_mcmc_bspbss.R
\name{sum_mcmc_bspbss}
\alias{sum_mcmc_bspbss}
\title{Summarization of the MCMC result.}
\usage{
sum_mcmc_bspbss(res, X, kernel, start = 1, end = 100, select_prob = 0.8)
}
\arguments{
\item{res}{List including MCMC samples, which can be obtained from function \code{mcmc_bspbss}}

\item{X}{Original data matrix.}

\item{kernel}{List including eigenvalues and eigenfunctions of the kernel, see \code{init_bspbss}.}

\item{start}{Start point of the iterations being summarized.}

\item{end}{End point of the iterations being summarized.}

\item{select_prob}{Lower bound of the posterior inclusion probability required when summarizing
the samples of latent sources.}
}
\value{
List that contains the following terms:
\describe{
  \item{S}{Estimated latent sources.}
  \item{pip}{Voxel-wise posterior inclusion probability for the latent sources.}
  \item{A}{Estimated mixing coefficent matrix.}
  \item{zeta}{Estimated zeta.}
  \item{sigma}{Estimated sigma.}
  \item{logLik}{Trace of log-likelihood.}
  \item{Slist}{MCMC samples of S.}
}
}
\description{
The function summarizes the MCMC results obtained from \code{mcmc_bspbss}.
}
\examples{

sim = sim_2Dimage(length = 30, sigma = 5e-4, n = 30, smooth = 6)
ini = init_bspbss(sim$X, sim$coords, q = 3, ker_par = c(0.1,50), num_eigen = 50)
res = mcmc_bspbss(ini$X,ini$init,ini$prior,ini$kernel,n.iter=200,n.burn_in=100,thin=10,show_step=50)
res_sum = sum_mcmc_bspbss(res, ini$X, ini$kernel, start = 11, end = 20, select_p = 0.5)

}
