% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSDA-package.R
\docType{data}
\name{Habits}
\alias{Habits}
\title{Study habits of students in two matched school districts}
\format{
A data frame/tibble with 11 observations on four variables
\describe{ 
\item{A}{study habit score} 
\item{B}{study habit score} 
\item{differ}{\code{B} minus \code{A}} 
\item{signrks}{the signed-ranked-differences} 
}
}
\usage{
Habits
}
\description{
Data for Exercise 7.57
}
\examples{

shapiro.test(Habits$differ)
qqnorm(Habits$differ)
qqline(Habits$differ)
wilcox.test(Habits$B, Habits$A, paired = TRUE, alternative = "less")
t.test(Habits$signrks, alternative = "less")

\dontrun{
library(ggplot2)
ggplot2::ggplot(data = Habits, aes(x = differ)) + 
           geom_dotplot(fill = "blue") + 
           theme_bw()
}

}
\references{
Kitchens, L. J. (2003) \emph{Basic Statistics and Data Analysis}.
Pacific Grove, CA: Brooks/Cole, a division of Thomson Learning.
}
\keyword{datasets}
