% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/subplot_summary.R
\name{subplot_summary}
\alias{subplot_summary}
\title{Summarise and display tree information by subplot}
\usage{
subplot_summary(
  subplots,
  value = NULL,
  draw_plot = TRUE,
  per_ha = TRUE,
  fun = sum,
  ...
)
}
\arguments{
\item{subplots}{output of the \code{\link[=divide_plot]{divide_plot()}} function}

\item{value}{a character indicating the column in subplots$tree_data (a tree metric) to be summarised}

\item{draw_plot}{a logical indicating whether the plot design should be displayed}

\item{per_ha}{a logical indicating whether the metric summary should be per hectare}

\item{fun}{the function to be applied}

\item{...}{optional arguments to fun}
}
\value{
a list containg the following elements :
\itemize{
\item \code{tree_summary} : a summary of the metric per subplot
\item \code{polygon} : an sf object : simple feature collection of the subplot's polygon
\item \code{plot_design} : a ggplot object (or a list of ggplot objects) that can easily be modified
}
}
\description{
After applying the \code{\link[=divide_plot]{divide_plot()}} function, this function summarises with any defined function the desired tree metric by sub-plot and displays the plot representation.
}
\examples{
# One plot with repeated measurements of each corner
data("NouraguesPlot201")
data("NouraguesTrees")
check_plot201 <- check_plot_coord(
  corner_data = NouraguesPlot201,
  proj_coord = c("Xutm","Yutm"), rel_coord = c("Xfield","Yfield"),
  trust_GPS_corners = TRUE, draw_plot = FALSE)
subplots_201 <- suppressWarnings(
  divide_plot(
    corner_data = check_plot201$corner_coord, 
    rel_coord = c("x_rel","y_rel"), proj_coord = c("x_proj","y_proj"),
    grid_size = 50,
    tree_data =  NouraguesTrees[NouraguesTrees$Plot == 201,],
    tree_coords = c("Xfield","Yfield")))
# Sum summary (by default) of diameter
subplots_201_sum <- subplot_summary(subplots_201 , value = "D", draw_plot = FALSE)
subplots_201_sum$tree_summary
subplots_201_sum$polygon
\donttest{
  subplots_201_sum$plot_design
}
# 9th quantile summary (for example) of diameter
subplots_201_quant <- subplot_summary(subplots_201 , value = "D", draw_plot = FALSE,
                                      fun = quantile, probs=0.9)
  

# Dealing with multiple plots
\dontrun{
  data("NouraguesCoords")
  nouragues_subplots <- suppressWarnings(
  divide_plot(
     corner_data = NouraguesCoords,
    rel_coord = c("Xfield","Yfield"), proj_coord = c("Xutm","Yutm"),
    corner_plot_ID = "Plot",
    grid_size = 50,
    tree_data = NouraguesTrees, tree_coords =  c("Xfield","Yfield"),
    tree_plot_ID = "Plot"))
  # Sum summary (by default)
  nouragues_sum <- subplot_summary(nouragues_subplots , value = "D", draw_plot = FALSE)
  nouragues_sum$tree_summary
  subplots_201_sum$plot_design
}

}
\author{
Arthur Bailly
}
