% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/numberCorner.R
\name{numberCorner}
\alias{numberCorner}
\title{Get the UTM coordinates with the corner of the plot}
\usage{
numberCorner(longlat = NULL, projCoord = NULL, plot, origin, clockWise)
}
\arguments{
\item{longlat}{(optional) data frame with the coordinates in longitude latitude (eg. cbind(longitude, latitude)).}

\item{projCoord}{(optional) data frame with the projected coordinates in X Y}

\item{plot}{A vector of codes (names) of the plots}

\item{origin}{A logical vector with TRUE corresponding of the origin of the axis of each plot.}

\item{clockWise}{A logical, whether the numbering should be done in a clockwise (TRUE) or counterclockwise (FALSE) way.}
}
\value{
A data frame with:
\itemize{
\item \code{plot}: The code of the plot
\item \code{X}: The coordinates X in UTM
\item \code{Y}: The coordinates Y in UTM
\item \code{corner}: The corner numbers
}
}
\description{
Get the UTM coordinates from the latitude and longitude of the corners of a plot.
The function also assign a number to the corners in a clockwise or counterclockwise way, with the number 1 for the XY origin.
Corner numbering is done as followed:
\itemize{
\item axis X: the corner 1 to the corner 2
\item axis Y: the corner 1 to the corner 4
}
}
\examples{
coord <- data.frame(X = c(0, 200, 0, 200), Y = c(0, 0, 200, 200)) + 5000
plot <- rep("plot1", 4)
origin <- c(FALSE, FALSE, TRUE, FALSE)

# if you turn clock wise
corner <- numberCorner(projCoord = coord, plot = plot, origin = origin, clockWise = TRUE)

# Plot the plot
plot(coord, asp = 1)
text(coord, labels = corner$corner, pos = 1)


# Using a counterclockwise way
corner <- numberCorner(projCoord = coord, plot = plot, origin = origin, clockWise = FALSE)

# Plot the plot
plot(coord, asp = 1)
text(coord, labels = corner$corner, pos = 1)
}
\author{
Arthur PERE, Maxime REJOU-MECHAIN
}
