% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulatePedigree.R
\name{buildBetweenGenerations}
\alias{buildBetweenGenerations}
\title{Process Generation Connections}
\usage{
buildBetweenGenerations(
  df_Fam,
  Ngen,
  sizeGens,
  verbose,
  marR,
  sexR,
  kpc,
  rd_kpc
)
}
\arguments{
\item{df_Fam}{A data frame containing the simulated pedigree information up to the current generation.
Must include columns for family ID, individual ID, generation number, spouse ID (spID),
and sex. This data frame is updated in place to include flags for parental status (ifparent),
son status (ifson), and daughter status (ifdau), as well as couple IDs.}

\item{Ngen}{Number of generations. An integer >= 2 that determines how many generations the simulated pedigree will have. The first generation is always a fertilized couple. The last generation has no mated individuals.}

\item{sizeGens}{A numeric vector containing the sizes of each generation within the pedigree.}

\item{verbose}{logical  If TRUE, print progress through stages of algorithm}

\item{marR}{Mating rate. A numeric value ranging from 0 to 1 which determines the proportion of mated (fertilized) couples in the pedigree within each generation. For instance, marR = 0.5 suggests 50 percent of the offspring in a specific generation will be mated and have their offspring.}

\item{sexR}{Sex ratio of offspring. A numeric value ranging from 0 to 1 that determines the proportion of males in all offspring in this pedigree. For instance, 0.4 means 40 percent of the offspring will be male.}

\item{kpc}{Number of kids per couple. An integer >= 2 that determines how many kids each fertilized mated couple will have in the pedigree. Default value is 3. Returns an error when kpc equals 1.}

\item{rd_kpc}{logical. If TRUE, the number of kids per mate will be randomly generated from a poisson distribution with mean kpc. If FALSE, the number of kids per mate will be fixed at kpc.}
}
\value{
The function updates the `df_Fam` data frame in place, adding or modifying columns related to parental and offspring status,
        as well as assigning unique couple IDs. It does not return a value explicitly.
}
\description{
This function processes connections between each two generations in a pedigree simulation.
It marks individuals as parents, sons, or daughters based on their generational position and relationships.
The function also handles the assignment of couple IDs, manages single and coupled individuals,
and establishes parent-offspring links across generations.
}
\details{
The function iterates through each generation, starting from the second, to establish connections based on mating and parentage.
For the first generation, it sets the parental status directly. For subsequent generations, it calculates the number of couples,
the expected number of offspring, and assigns offspring to parents. It handles gender-based assignments for sons and daughters,
and deals with the nuances of single individuals and couple formation. The function relies on external functions `assignCoupleIds`
and `adjustKidsPerCouple` to handle specific tasks related to couple ID assignment and offspring number adjustments, respectively.
}
