% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/compute_xxx.R
\name{compute_kstar}
\alias{compute_kstar}
\title{Compute k^*}
\usage{
compute_kstar(k, best, ref)
}
\arguments{
\item{k}{Willingness-to-pay grid approximation of the budget willing to invest (vector)}

\item{best}{Best intervention for each \code{k} (int)}

\item{ref}{Reference intervention (int)}
}
\value{
integer representing intervention
}
\description{
Find willingness-to-pay threshold when optimal decision changes.
}
\details{
\deqn{k^* := \min\{k : IB < 0 \}}

The value of the break-even point corresponds to the ICER and quantifies
the point at which the decision-maker is indifferent between the two options.
}
\seealso{
\code{\link[=ceac.plot]{ceac.plot()}}
}
